/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.IpRange;
import com.amazonaws.services.ec2.model.PrefixListId;
import com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.UserIdGroupPair;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RevokeSecurityGroupIngressRequestMarshaller
implements Marshaller<Request<RevokeSecurityGroupIngressRequest>, RevokeSecurityGroupIngressRequest> {
    @Override
    public Request<RevokeSecurityGroupIngressRequest> marshall(RevokeSecurityGroupIngressRequest revokeSecurityGroupIngressRequest) {
        SdkInternalList revokeSecurityGroupIngressRequestIpPermissionsList;
        if (revokeSecurityGroupIngressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RevokeSecurityGroupIngressRequest> request = new DefaultRequest<RevokeSecurityGroupIngressRequest>(revokeSecurityGroupIngressRequest, "AmazonEC2");
        request.addParameter("Action", "RevokeSecurityGroupIngress");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (revokeSecurityGroupIngressRequest.getGroupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString(revokeSecurityGroupIngressRequest.getGroupName()));
        }
        if (revokeSecurityGroupIngressRequest.getGroupId() != null) {
            request.addParameter("GroupId", StringUtils.fromString(revokeSecurityGroupIngressRequest.getGroupId()));
        }
        if (revokeSecurityGroupIngressRequest.getSourceSecurityGroupName() != null) {
            request.addParameter("SourceSecurityGroupName", StringUtils.fromString(revokeSecurityGroupIngressRequest.getSourceSecurityGroupName()));
        }
        if (revokeSecurityGroupIngressRequest.getSourceSecurityGroupOwnerId() != null) {
            request.addParameter("SourceSecurityGroupOwnerId", StringUtils.fromString(revokeSecurityGroupIngressRequest.getSourceSecurityGroupOwnerId()));
        }
        if (revokeSecurityGroupIngressRequest.getIpProtocol() != null) {
            request.addParameter("IpProtocol", StringUtils.fromString(revokeSecurityGroupIngressRequest.getIpProtocol()));
        }
        if (revokeSecurityGroupIngressRequest.getFromPort() != null) {
            request.addParameter("FromPort", StringUtils.fromInteger(revokeSecurityGroupIngressRequest.getFromPort()));
        }
        if (revokeSecurityGroupIngressRequest.getToPort() != null) {
            request.addParameter("ToPort", StringUtils.fromInteger(revokeSecurityGroupIngressRequest.getToPort()));
        }
        if (revokeSecurityGroupIngressRequest.getCidrIp() != null) {
            request.addParameter("CidrIp", StringUtils.fromString(revokeSecurityGroupIngressRequest.getCidrIp()));
        }
        if (!(revokeSecurityGroupIngressRequestIpPermissionsList = (SdkInternalList)revokeSecurityGroupIngressRequest.getIpPermissions()).isEmpty() || !revokeSecurityGroupIngressRequestIpPermissionsList.isAutoConstruct()) {
            int ipPermissionsListIndex = 1;
            for (IpPermission revokeSecurityGroupIngressRequestIpPermissionsListValue : revokeSecurityGroupIngressRequestIpPermissionsList) {
                SdkInternalList ipPermissionIpv4RangesList;
                SdkInternalList ipPermissionPrefixListIdsList;
                SdkInternalList ipPermissionUserIdGroupPairsList;
                if (revokeSecurityGroupIngressRequestIpPermissionsListValue.getIpProtocol() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpProtocol", StringUtils.fromString(revokeSecurityGroupIngressRequestIpPermissionsListValue.getIpProtocol()));
                }
                if (revokeSecurityGroupIngressRequestIpPermissionsListValue.getFromPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".FromPort", StringUtils.fromInteger(revokeSecurityGroupIngressRequestIpPermissionsListValue.getFromPort()));
                }
                if (revokeSecurityGroupIngressRequestIpPermissionsListValue.getToPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".ToPort", StringUtils.fromInteger(revokeSecurityGroupIngressRequestIpPermissionsListValue.getToPort()));
                }
                if (!(ipPermissionUserIdGroupPairsList = (SdkInternalList)revokeSecurityGroupIngressRequestIpPermissionsListValue.getUserIdGroupPairs()).isEmpty() || !ipPermissionUserIdGroupPairsList.isAutoConstruct()) {
                    int userIdGroupPairsListIndex = 1;
                    for (Object ipPermissionUserIdGroupPairsListValue : ipPermissionUserIdGroupPairsList) {
                        if (((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getUserId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".UserId", StringUtils.fromString(((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getUserId()));
                        }
                        if (((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getGroupName() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".GroupName", StringUtils.fromString(((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getGroupName()));
                        }
                        if (((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getGroupId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".GroupId", StringUtils.fromString(((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getGroupId()));
                        }
                        if (((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getVpcId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".VpcId", StringUtils.fromString(((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getVpcId()));
                        }
                        if (((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getVpcPeeringConnectionId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".VpcPeeringConnectionId", StringUtils.fromString(((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getVpcPeeringConnectionId()));
                        }
                        if (((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getPeeringStatus() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".PeeringStatus", StringUtils.fromString(((UserIdGroupPair)ipPermissionUserIdGroupPairsListValue).getPeeringStatus()));
                        }
                        ++userIdGroupPairsListIndex;
                    }
                }
                if (!(ipPermissionPrefixListIdsList = (SdkInternalList)revokeSecurityGroupIngressRequestIpPermissionsListValue.getPrefixListIds()).isEmpty() || !ipPermissionPrefixListIdsList.isAutoConstruct()) {
                    Object ipPermissionUserIdGroupPairsListValue;
                    int prefixListIdsListIndex = 1;
                    ipPermissionUserIdGroupPairsListValue = ipPermissionPrefixListIdsList.iterator();
                    while (ipPermissionUserIdGroupPairsListValue.hasNext()) {
                        PrefixListId ipPermissionPrefixListIdsListValue = (PrefixListId)ipPermissionUserIdGroupPairsListValue.next();
                        if (ipPermissionPrefixListIdsListValue.getPrefixListId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".PrefixListIds." + prefixListIdsListIndex + ".PrefixListId", StringUtils.fromString(ipPermissionPrefixListIdsListValue.getPrefixListId()));
                        }
                        ++prefixListIdsListIndex;
                    }
                }
                if (!(ipPermissionIpv4RangesList = (SdkInternalList)revokeSecurityGroupIngressRequestIpPermissionsListValue.getIpv4Ranges()).isEmpty() || !ipPermissionIpv4RangesList.isAutoConstruct()) {
                    int ipv4RangesListIndex = 1;
                    for (IpRange ipPermissionIpv4RangesListValue : ipPermissionIpv4RangesList) {
                        if (ipPermissionIpv4RangesListValue.getCidrIp() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpRanges." + ipv4RangesListIndex + ".CidrIp", StringUtils.fromString(ipPermissionIpv4RangesListValue.getCidrIp()));
                        }
                        ++ipv4RangesListIndex;
                    }
                }
                ++ipPermissionsListIndex;
            }
        }
        return request;
    }
}

