/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.databasemigrationservice.model.ReplicationInstance;
import com.amazonaws.services.databasemigrationservice.model.VpcSecurityGroupMembership;
import com.amazonaws.services.databasemigrationservice.model.transform.ReplicationPendingModifiedValuesJsonMarshaller;
import com.amazonaws.services.databasemigrationservice.model.transform.ReplicationSubnetGroupJsonMarshaller;
import com.amazonaws.services.databasemigrationservice.model.transform.VpcSecurityGroupMembershipJsonMarshaller;
import java.util.List;

public class ReplicationInstanceJsonMarshaller {
    private static ReplicationInstanceJsonMarshaller instance;

    public void marshall(ReplicationInstance replicationInstance, StructuredJsonGenerator jsonGenerator) {
        if (replicationInstance == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> list;
            List<String> replicationInstancePublicIpAddressesList;
            List<VpcSecurityGroupMembership> vpcSecurityGroupsList;
            jsonGenerator.writeStartObject();
            if (replicationInstance.getReplicationInstanceIdentifier() != null) {
                jsonGenerator.writeFieldName("ReplicationInstanceIdentifier").writeValue(replicationInstance.getReplicationInstanceIdentifier());
            }
            if (replicationInstance.getReplicationInstanceClass() != null) {
                jsonGenerator.writeFieldName("ReplicationInstanceClass").writeValue(replicationInstance.getReplicationInstanceClass());
            }
            if (replicationInstance.getReplicationInstanceStatus() != null) {
                jsonGenerator.writeFieldName("ReplicationInstanceStatus").writeValue(replicationInstance.getReplicationInstanceStatus());
            }
            if (replicationInstance.getAllocatedStorage() != null) {
                jsonGenerator.writeFieldName("AllocatedStorage").writeValue(replicationInstance.getAllocatedStorage());
            }
            if (replicationInstance.getInstanceCreateTime() != null) {
                jsonGenerator.writeFieldName("InstanceCreateTime").writeValue(replicationInstance.getInstanceCreateTime());
            }
            if ((vpcSecurityGroupsList = replicationInstance.getVpcSecurityGroups()) != null) {
                jsonGenerator.writeFieldName("VpcSecurityGroups");
                jsonGenerator.writeStartArray();
                for (VpcSecurityGroupMembership vpcSecurityGroupMembership : vpcSecurityGroupsList) {
                    if (vpcSecurityGroupMembership == null) continue;
                    VpcSecurityGroupMembershipJsonMarshaller.getInstance().marshall(vpcSecurityGroupMembership, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (replicationInstance.getAvailabilityZone() != null) {
                jsonGenerator.writeFieldName("AvailabilityZone").writeValue(replicationInstance.getAvailabilityZone());
            }
            if (replicationInstance.getReplicationSubnetGroup() != null) {
                jsonGenerator.writeFieldName("ReplicationSubnetGroup");
                ReplicationSubnetGroupJsonMarshaller.getInstance().marshall(replicationInstance.getReplicationSubnetGroup(), jsonGenerator);
            }
            if (replicationInstance.getPreferredMaintenanceWindow() != null) {
                jsonGenerator.writeFieldName("PreferredMaintenanceWindow").writeValue(replicationInstance.getPreferredMaintenanceWindow());
            }
            if (replicationInstance.getPendingModifiedValues() != null) {
                jsonGenerator.writeFieldName("PendingModifiedValues");
                ReplicationPendingModifiedValuesJsonMarshaller.getInstance().marshall(replicationInstance.getPendingModifiedValues(), jsonGenerator);
            }
            if (replicationInstance.getMultiAZ() != null) {
                jsonGenerator.writeFieldName("MultiAZ").writeValue(replicationInstance.getMultiAZ());
            }
            if (replicationInstance.getEngineVersion() != null) {
                jsonGenerator.writeFieldName("EngineVersion").writeValue(replicationInstance.getEngineVersion());
            }
            if (replicationInstance.getAutoMinorVersionUpgrade() != null) {
                jsonGenerator.writeFieldName("AutoMinorVersionUpgrade").writeValue(replicationInstance.getAutoMinorVersionUpgrade());
            }
            if (replicationInstance.getKmsKeyId() != null) {
                jsonGenerator.writeFieldName("KmsKeyId").writeValue(replicationInstance.getKmsKeyId());
            }
            if (replicationInstance.getReplicationInstanceArn() != null) {
                jsonGenerator.writeFieldName("ReplicationInstanceArn").writeValue(replicationInstance.getReplicationInstanceArn());
            }
            if (replicationInstance.getReplicationInstancePublicIpAddress() != null) {
                jsonGenerator.writeFieldName("ReplicationInstancePublicIpAddress").writeValue(replicationInstance.getReplicationInstancePublicIpAddress());
            }
            if (replicationInstance.getReplicationInstancePrivateIpAddress() != null) {
                jsonGenerator.writeFieldName("ReplicationInstancePrivateIpAddress").writeValue(replicationInstance.getReplicationInstancePrivateIpAddress());
            }
            if ((replicationInstancePublicIpAddressesList = replicationInstance.getReplicationInstancePublicIpAddresses()) != null) {
                jsonGenerator.writeFieldName("ReplicationInstancePublicIpAddresses");
                jsonGenerator.writeStartArray();
                for (String replicationInstancePublicIpAddressesListValue : replicationInstancePublicIpAddressesList) {
                    if (replicationInstancePublicIpAddressesListValue == null) continue;
                    jsonGenerator.writeValue(replicationInstancePublicIpAddressesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list = replicationInstance.getReplicationInstancePrivateIpAddresses()) != null) {
                jsonGenerator.writeFieldName("ReplicationInstancePrivateIpAddresses");
                jsonGenerator.writeStartArray();
                for (String replicationInstancePrivateIpAddressesListValue : list) {
                    if (replicationInstancePrivateIpAddressesListValue == null) continue;
                    jsonGenerator.writeValue(replicationInstancePrivateIpAddressesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (replicationInstance.getPubliclyAccessible() != null) {
                jsonGenerator.writeFieldName("PubliclyAccessible").writeValue(replicationInstance.getPubliclyAccessible());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ReplicationInstanceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ReplicationInstanceJsonMarshaller();
        }
        return instance;
    }
}

