/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.ConfirmSignUpRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ConfirmSignUpRequestMarshaller
implements Marshaller<Request<ConfirmSignUpRequest>, ConfirmSignUpRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ConfirmSignUpRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ConfirmSignUpRequest> marshall(ConfirmSignUpRequest confirmSignUpRequest) {
        if (confirmSignUpRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ConfirmSignUpRequest> request = new DefaultRequest<ConfirmSignUpRequest>(confirmSignUpRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.ConfirmSignUp");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (confirmSignUpRequest.getClientId() != null) {
                jsonGenerator.writeFieldName("ClientId").writeValue(confirmSignUpRequest.getClientId());
            }
            if (confirmSignUpRequest.getSecretHash() != null) {
                jsonGenerator.writeFieldName("SecretHash").writeValue(confirmSignUpRequest.getSecretHash());
            }
            if (confirmSignUpRequest.getUsername() != null) {
                jsonGenerator.writeFieldName("Username").writeValue(confirmSignUpRequest.getUsername());
            }
            if (confirmSignUpRequest.getConfirmationCode() != null) {
                jsonGenerator.writeFieldName("ConfirmationCode").writeValue(confirmSignUpRequest.getConfirmationCode());
            }
            if (confirmSignUpRequest.getForceAliasCreation() != null) {
                jsonGenerator.writeFieldName("ForceAliasCreation").writeValue(confirmSignUpRequest.getForceAliasCreation());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

