/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cloudtrail.model.Trail;

public class TrailJsonMarshaller {
    private static TrailJsonMarshaller instance;

    public void marshall(Trail trail, StructuredJsonGenerator jsonGenerator) {
        if (trail == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (trail.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(trail.getName());
            }
            if (trail.getS3BucketName() != null) {
                jsonGenerator.writeFieldName("S3BucketName").writeValue(trail.getS3BucketName());
            }
            if (trail.getS3KeyPrefix() != null) {
                jsonGenerator.writeFieldName("S3KeyPrefix").writeValue(trail.getS3KeyPrefix());
            }
            if (trail.getSnsTopicName() != null) {
                jsonGenerator.writeFieldName("SnsTopicName").writeValue(trail.getSnsTopicName());
            }
            if (trail.getSnsTopicARN() != null) {
                jsonGenerator.writeFieldName("SnsTopicARN").writeValue(trail.getSnsTopicARN());
            }
            if (trail.getIncludeGlobalServiceEvents() != null) {
                jsonGenerator.writeFieldName("IncludeGlobalServiceEvents").writeValue(trail.getIncludeGlobalServiceEvents());
            }
            if (trail.getIsMultiRegionTrail() != null) {
                jsonGenerator.writeFieldName("IsMultiRegionTrail").writeValue(trail.getIsMultiRegionTrail());
            }
            if (trail.getHomeRegion() != null) {
                jsonGenerator.writeFieldName("HomeRegion").writeValue(trail.getHomeRegion());
            }
            if (trail.getTrailARN() != null) {
                jsonGenerator.writeFieldName("TrailARN").writeValue(trail.getTrailARN());
            }
            if (trail.getLogFileValidationEnabled() != null) {
                jsonGenerator.writeFieldName("LogFileValidationEnabled").writeValue(trail.getLogFileValidationEnabled());
            }
            if (trail.getCloudWatchLogsLogGroupArn() != null) {
                jsonGenerator.writeFieldName("CloudWatchLogsLogGroupArn").writeValue(trail.getCloudWatchLogsLogGroupArn());
            }
            if (trail.getCloudWatchLogsRoleArn() != null) {
                jsonGenerator.writeFieldName("CloudWatchLogsRoleArn").writeValue(trail.getCloudWatchLogsRoleArn());
            }
            if (trail.getKmsKeyId() != null) {
                jsonGenerator.writeFieldName("KmsKeyId").writeValue(trail.getKmsKeyId());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TrailJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TrailJsonMarshaller();
        }
        return instance;
    }
}

