/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.budgets.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.budgets.model.DescribeBudgetsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeBudgetsRequestMarshaller
implements Marshaller<Request<DescribeBudgetsRequest>, DescribeBudgetsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeBudgetsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeBudgetsRequest> marshall(DescribeBudgetsRequest describeBudgetsRequest) {
        if (describeBudgetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeBudgetsRequest> request = new DefaultRequest<DescribeBudgetsRequest>(describeBudgetsRequest, "AWSBudgets");
        request.addHeader("X-Amz-Target", "AWSBudgetServiceGateway.DescribeBudgets");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeBudgetsRequest.getAccountId() != null) {
                jsonGenerator.writeFieldName("AccountId").writeValue(describeBudgetsRequest.getAccountId());
            }
            if (describeBudgetsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(describeBudgetsRequest.getMaxResults());
            }
            if (describeBudgetsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeBudgetsRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

