/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.DeleteDomainNameRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DeleteDomainNameRequestMarshaller
implements Marshaller<Request<DeleteDomainNameRequest>, DeleteDomainNameRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteDomainNameRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteDomainNameRequest> marshall(DeleteDomainNameRequest deleteDomainNameRequest) {
        if (deleteDomainNameRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteDomainNameRequest> request = new DefaultRequest<DeleteDomainNameRequest>(deleteDomainNameRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/domainnames/{domain_name}";
        uriResourcePath = uriResourcePath.replace("{domain_name}", deleteDomainNameRequest.getDomainName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteDomainNameRequest.getDomainName()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

