/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CopyDBSnapshotRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String sourceDBSnapshotIdentifier;
    private String targetDBSnapshotIdentifier;
    private String kmsKeyId;
    private SdkInternalList<Tag> tags;
    private Boolean copyTags;

    public void setSourceDBSnapshotIdentifier(String sourceDBSnapshotIdentifier) {
        this.sourceDBSnapshotIdentifier = sourceDBSnapshotIdentifier;
    }

    public String getSourceDBSnapshotIdentifier() {
        return this.sourceDBSnapshotIdentifier;
    }

    public CopyDBSnapshotRequest withSourceDBSnapshotIdentifier(String sourceDBSnapshotIdentifier) {
        this.setSourceDBSnapshotIdentifier(sourceDBSnapshotIdentifier);
        return this;
    }

    public void setTargetDBSnapshotIdentifier(String targetDBSnapshotIdentifier) {
        this.targetDBSnapshotIdentifier = targetDBSnapshotIdentifier;
    }

    public String getTargetDBSnapshotIdentifier() {
        return this.targetDBSnapshotIdentifier;
    }

    public CopyDBSnapshotRequest withTargetDBSnapshotIdentifier(String targetDBSnapshotIdentifier) {
        this.setTargetDBSnapshotIdentifier(targetDBSnapshotIdentifier);
        return this;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public CopyDBSnapshotRequest withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(tags);
    }

    public CopyDBSnapshotRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CopyDBSnapshotRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setCopyTags(Boolean copyTags) {
        this.copyTags = copyTags;
    }

    public Boolean getCopyTags() {
        return this.copyTags;
    }

    public CopyDBSnapshotRequest withCopyTags(Boolean copyTags) {
        this.setCopyTags(copyTags);
        return this;
    }

    public Boolean isCopyTags() {
        return this.copyTags;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceDBSnapshotIdentifier() != null) {
            sb.append("SourceDBSnapshotIdentifier: " + this.getSourceDBSnapshotIdentifier() + ",");
        }
        if (this.getTargetDBSnapshotIdentifier() != null) {
            sb.append("TargetDBSnapshotIdentifier: " + this.getTargetDBSnapshotIdentifier() + ",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: " + this.getKmsKeyId() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags() + ",");
        }
        if (this.getCopyTags() != null) {
            sb.append("CopyTags: " + this.getCopyTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyDBSnapshotRequest)) {
            return false;
        }
        CopyDBSnapshotRequest other = (CopyDBSnapshotRequest)obj;
        if (other.getSourceDBSnapshotIdentifier() == null ^ this.getSourceDBSnapshotIdentifier() == null) {
            return false;
        }
        if (other.getSourceDBSnapshotIdentifier() != null && !other.getSourceDBSnapshotIdentifier().equals(this.getSourceDBSnapshotIdentifier())) {
            return false;
        }
        if (other.getTargetDBSnapshotIdentifier() == null ^ this.getTargetDBSnapshotIdentifier() == null) {
            return false;
        }
        if (other.getTargetDBSnapshotIdentifier() != null && !other.getTargetDBSnapshotIdentifier().equals(this.getTargetDBSnapshotIdentifier())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getCopyTags() == null ^ this.getCopyTags() == null) {
            return false;
        }
        return other.getCopyTags() == null || other.getCopyTags().equals(this.getCopyTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceDBSnapshotIdentifier() == null ? 0 : this.getSourceDBSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getTargetDBSnapshotIdentifier() == null ? 0 : this.getTargetDBSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getCopyTags() == null ? 0 : this.getCopyTags().hashCode());
        return hashCode;
    }

    @Override
    public CopyDBSnapshotRequest clone() {
        return (CopyDBSnapshotRequest)super.clone();
    }
}

