/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.iot.model.CreateThingTypeRequest;
import com.amazonaws.services.iot.model.transform.ThingTypePropertiesJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class CreateThingTypeRequestMarshaller
implements Marshaller<Request<CreateThingTypeRequest>, CreateThingTypeRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateThingTypeRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateThingTypeRequest> marshall(CreateThingTypeRequest createThingTypeRequest) {
        if (createThingTypeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateThingTypeRequest> request = new DefaultRequest<CreateThingTypeRequest>(createThingTypeRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/thing-types/{thingTypeName}";
        uriResourcePath = uriResourcePath.replace("{thingTypeName}", createThingTypeRequest.getThingTypeName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(createThingTypeRequest.getThingTypeName()), false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createThingTypeRequest.getThingTypeProperties() != null) {
                jsonGenerator.writeFieldName("thingTypeProperties");
                ThingTypePropertiesJsonMarshaller.getInstance().marshall(createThingTypeRequest.getThingTypeProperties(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

