/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.glacier.model.AbortMultipartUploadRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class AbortMultipartUploadRequestMarshaller
implements Marshaller<Request<AbortMultipartUploadRequest>, AbortMultipartUploadRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public AbortMultipartUploadRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<AbortMultipartUploadRequest> marshall(AbortMultipartUploadRequest abortMultipartUploadRequest) {
        if (abortMultipartUploadRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AbortMultipartUploadRequest> request = new DefaultRequest<AbortMultipartUploadRequest>(abortMultipartUploadRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}";
        uriResourcePath = uriResourcePath.replace("{accountId}", abortMultipartUploadRequest.getAccountId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(abortMultipartUploadRequest.getAccountId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{vaultName}", abortMultipartUploadRequest.getVaultName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(abortMultipartUploadRequest.getVaultName()), false) : "");
        uriResourcePath = uriResourcePath.replace("{uploadId}", abortMultipartUploadRequest.getUploadId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(abortMultipartUploadRequest.getUploadId()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

