/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticmapreduce.model.Configuration;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig;
import com.amazonaws.services.elasticmapreduce.model.transform.ConfigurationJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.EbsConfigurationJsonMarshaller;

public class InstanceGroupConfigJsonMarshaller {
    private static InstanceGroupConfigJsonMarshaller instance;

    public void marshall(InstanceGroupConfig instanceGroupConfig, StructuredJsonGenerator jsonGenerator) {
        if (instanceGroupConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList configurationsList;
            jsonGenerator.writeStartObject();
            if (instanceGroupConfig.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(instanceGroupConfig.getName());
            }
            if (instanceGroupConfig.getMarket() != null) {
                jsonGenerator.writeFieldName("Market").writeValue(instanceGroupConfig.getMarket());
            }
            if (instanceGroupConfig.getInstanceRole() != null) {
                jsonGenerator.writeFieldName("InstanceRole").writeValue(instanceGroupConfig.getInstanceRole());
            }
            if (instanceGroupConfig.getBidPrice() != null) {
                jsonGenerator.writeFieldName("BidPrice").writeValue(instanceGroupConfig.getBidPrice());
            }
            if (instanceGroupConfig.getInstanceType() != null) {
                jsonGenerator.writeFieldName("InstanceType").writeValue(instanceGroupConfig.getInstanceType());
            }
            if (instanceGroupConfig.getInstanceCount() != null) {
                jsonGenerator.writeFieldName("InstanceCount").writeValue(instanceGroupConfig.getInstanceCount());
            }
            if (!(configurationsList = (SdkInternalList)instanceGroupConfig.getConfigurations()).isEmpty() || !configurationsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Configurations");
                jsonGenerator.writeStartArray();
                for (Configuration configurationsListValue : configurationsList) {
                    if (configurationsListValue == null) continue;
                    ConfigurationJsonMarshaller.getInstance().marshall(configurationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (instanceGroupConfig.getEbsConfiguration() != null) {
                jsonGenerator.writeFieldName("EbsConfiguration");
                EbsConfigurationJsonMarshaller.getInstance().marshall(instanceGroupConfig.getEbsConfiguration(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static InstanceGroupConfigJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceGroupConfigJsonMarshaller();
        }
        return instance;
    }
}

