/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.services.elasticmapreduce.model.Application;
import com.amazonaws.services.elasticmapreduce.model.Cluster;
import com.amazonaws.services.elasticmapreduce.model.Configuration;
import com.amazonaws.services.elasticmapreduce.model.Tag;
import com.amazonaws.services.elasticmapreduce.model.transform.ApplicationJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ClusterStatusJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ConfigurationJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.Ec2InstanceAttributesJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.TagJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class ClusterJsonUnmarshaller
implements Unmarshaller<Cluster, JsonUnmarshallerContext> {
    private static ClusterJsonUnmarshaller instance;

    @Override
    public Cluster unmarshall(JsonUnmarshallerContext context) throws Exception {
        Cluster cluster = new Cluster();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Id", targetDepth)) {
                    context.nextToken();
                    cluster.setId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    cluster.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    cluster.setStatus(ClusterStatusJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Ec2InstanceAttributes", targetDepth)) {
                    context.nextToken();
                    cluster.setEc2InstanceAttributes(Ec2InstanceAttributesJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("LogUri", targetDepth)) {
                    context.nextToken();
                    cluster.setLogUri(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("RequestedAmiVersion", targetDepth)) {
                    context.nextToken();
                    cluster.setRequestedAmiVersion(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("RunningAmiVersion", targetDepth)) {
                    context.nextToken();
                    cluster.setRunningAmiVersion(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ReleaseLabel", targetDepth)) {
                    context.nextToken();
                    cluster.setReleaseLabel(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("AutoTerminate", targetDepth)) {
                    context.nextToken();
                    cluster.setAutoTerminate(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("TerminationProtected", targetDepth)) {
                    context.nextToken();
                    cluster.setTerminationProtected(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("VisibleToAllUsers", targetDepth)) {
                    context.nextToken();
                    cluster.setVisibleToAllUsers(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("Applications", targetDepth)) {
                    context.nextToken();
                    cluster.setApplications(new ListUnmarshaller<Application>(ApplicationJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("Tags", targetDepth)) {
                    context.nextToken();
                    cluster.setTags(new ListUnmarshaller<Tag>(TagJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("ServiceRole", targetDepth)) {
                    context.nextToken();
                    cluster.setServiceRole(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("NormalizedInstanceHours", targetDepth)) {
                    context.nextToken();
                    cluster.setNormalizedInstanceHours(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("MasterPublicDnsName", targetDepth)) {
                    context.nextToken();
                    cluster.setMasterPublicDnsName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Configurations", targetDepth)) {
                    context.nextToken();
                    cluster.setConfigurations(new ListUnmarshaller<Configuration>(ConfigurationJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("SecurityConfiguration", targetDepth)) {
                    context.nextToken();
                    cluster.setSecurityConfiguration(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return cluster;
    }

    public static ClusterJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ClusterJsonUnmarshaller();
        }
        return instance;
    }
}

