/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.NetworkBinding;

public class NetworkBindingJsonMarshaller {
    private static NetworkBindingJsonMarshaller instance;

    public void marshall(NetworkBinding networkBinding, StructuredJsonGenerator jsonGenerator) {
        if (networkBinding == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (networkBinding.getBindIP() != null) {
                jsonGenerator.writeFieldName("bindIP").writeValue(networkBinding.getBindIP());
            }
            if (networkBinding.getContainerPort() != null) {
                jsonGenerator.writeFieldName("containerPort").writeValue(networkBinding.getContainerPort());
            }
            if (networkBinding.getHostPort() != null) {
                jsonGenerator.writeFieldName("hostPort").writeValue(networkBinding.getHostPort());
            }
            if (networkBinding.getProtocol() != null) {
                jsonGenerator.writeFieldName("protocol").writeValue(networkBinding.getProtocol());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static NetworkBindingJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new NetworkBindingJsonMarshaller();
        }
        return instance;
    }
}

