/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.DescribeTasksRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeTasksRequestMarshaller
implements Marshaller<Request<DescribeTasksRequest>, DescribeTasksRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeTasksRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeTasksRequest> marshall(DescribeTasksRequest describeTasksRequest) {
        if (describeTasksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeTasksRequest> request = new DefaultRequest<DescribeTasksRequest>(describeTasksRequest, "AmazonECS");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerServiceV20141113.DescribeTasks");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList tasksList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeTasksRequest.getCluster() != null) {
                jsonGenerator.writeFieldName("cluster").writeValue(describeTasksRequest.getCluster());
            }
            if (!(tasksList = (SdkInternalList)describeTasksRequest.getTasks()).isEmpty() || !tasksList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("tasks");
                jsonGenerator.writeStartArray();
                for (String tasksListValue : tasksList) {
                    if (tasksListValue == null) continue;
                    jsonGenerator.writeValue(tasksListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

