/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.datapipeline.model.QueryObjectsRequest;
import com.amazonaws.services.datapipeline.model.transform.QueryJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class QueryObjectsRequestMarshaller
implements Marshaller<Request<QueryObjectsRequest>, QueryObjectsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public QueryObjectsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<QueryObjectsRequest> marshall(QueryObjectsRequest queryObjectsRequest) {
        if (queryObjectsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<QueryObjectsRequest> request = new DefaultRequest<QueryObjectsRequest>(queryObjectsRequest, "DataPipeline");
        request.addHeader("X-Amz-Target", "DataPipeline.QueryObjects");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (queryObjectsRequest.getPipelineId() != null) {
                jsonGenerator.writeFieldName("pipelineId").writeValue(queryObjectsRequest.getPipelineId());
            }
            if (queryObjectsRequest.getQuery() != null) {
                jsonGenerator.writeFieldName("query");
                QueryJsonMarshaller.getInstance().marshall(queryObjectsRequest.getQuery(), jsonGenerator);
            }
            if (queryObjectsRequest.getSphere() != null) {
                jsonGenerator.writeFieldName("sphere").writeValue(queryObjectsRequest.getSphere());
            }
            if (queryObjectsRequest.getMarker() != null) {
                jsonGenerator.writeFieldName("marker").writeValue(queryObjectsRequest.getMarker());
            }
            if (queryObjectsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("limit").writeValue(queryObjectsRequest.getLimit());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

