/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentDescription;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentParameter;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DocumentParameterJsonMarshaller;

public class DocumentDescriptionJsonMarshaller {
    private static DocumentDescriptionJsonMarshaller instance;

    public void marshall(DocumentDescription documentDescription, StructuredJsonGenerator jsonGenerator) {
        if (documentDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList platformTypesList;
            SdkInternalList parametersList;
            jsonGenerator.writeStartObject();
            if (documentDescription.getSha1() != null) {
                jsonGenerator.writeFieldName("Sha1").writeValue(documentDescription.getSha1());
            }
            if (documentDescription.getHash() != null) {
                jsonGenerator.writeFieldName("Hash").writeValue(documentDescription.getHash());
            }
            if (documentDescription.getHashType() != null) {
                jsonGenerator.writeFieldName("HashType").writeValue(documentDescription.getHashType());
            }
            if (documentDescription.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(documentDescription.getName());
            }
            if (documentDescription.getOwner() != null) {
                jsonGenerator.writeFieldName("Owner").writeValue(documentDescription.getOwner());
            }
            if (documentDescription.getCreatedDate() != null) {
                jsonGenerator.writeFieldName("CreatedDate").writeValue(documentDescription.getCreatedDate());
            }
            if (documentDescription.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(documentDescription.getStatus());
            }
            if (documentDescription.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(documentDescription.getDescription());
            }
            if (!(parametersList = (SdkInternalList)documentDescription.getParameters()).isEmpty() || !parametersList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Parameters");
                jsonGenerator.writeStartArray();
                for (DocumentParameter parametersListValue : parametersList) {
                    if (parametersListValue == null) continue;
                    DocumentParameterJsonMarshaller.getInstance().marshall(parametersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(platformTypesList = (SdkInternalList)documentDescription.getPlatformTypes()).isEmpty() || !platformTypesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("PlatformTypes");
                jsonGenerator.writeStartArray();
                for (String platformTypesListValue : platformTypesList) {
                    if (platformTypesListValue == null) continue;
                    jsonGenerator.writeValue(platformTypesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DocumentDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DocumentDescriptionJsonMarshaller();
        }
        return instance;
    }
}

