/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworks.model.DescribeRdsDbInstancesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeRdsDbInstancesRequestMarshaller
implements Marshaller<Request<DescribeRdsDbInstancesRequest>, DescribeRdsDbInstancesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeRdsDbInstancesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeRdsDbInstancesRequest> marshall(DescribeRdsDbInstancesRequest describeRdsDbInstancesRequest) {
        if (describeRdsDbInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeRdsDbInstancesRequest> request = new DefaultRequest<DescribeRdsDbInstancesRequest>(describeRdsDbInstancesRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.DescribeRdsDbInstances");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList rdsDbInstanceArnsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeRdsDbInstancesRequest.getStackId() != null) {
                jsonGenerator.writeFieldName("StackId").writeValue(describeRdsDbInstancesRequest.getStackId());
            }
            if (!(rdsDbInstanceArnsList = (SdkInternalList)describeRdsDbInstancesRequest.getRdsDbInstanceArns()).isEmpty() || !rdsDbInstanceArnsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("RdsDbInstanceArns");
                jsonGenerator.writeStartArray();
                for (String rdsDbInstanceArnsListValue : rdsDbInstanceArnsList) {
                    if (rdsDbInstanceArnsListValue == null) continue;
                    jsonGenerator.writeValue(rdsDbInstanceArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

