/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.glacier.model.GetDataRetrievalPolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetDataRetrievalPolicyRequestMarshaller
implements Marshaller<Request<GetDataRetrievalPolicyRequest>, GetDataRetrievalPolicyRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetDataRetrievalPolicyRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetDataRetrievalPolicyRequest> marshall(GetDataRetrievalPolicyRequest getDataRetrievalPolicyRequest) {
        if (getDataRetrievalPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetDataRetrievalPolicyRequest> request = new DefaultRequest<GetDataRetrievalPolicyRequest>(getDataRetrievalPolicyRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{accountId}/policies/data-retrieval";
        uriResourcePath = uriResourcePath.replace("{accountId}", getDataRetrievalPolicyRequest.getAccountId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getDataRetrievalPolicyRequest.getAccountId()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

