/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.gamelift.model.Build;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListBuildsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Build> builds;
    private String nextToken;

    public List<Build> getBuilds() {
        return this.builds;
    }

    public void setBuilds(Collection<Build> builds) {
        if (builds == null) {
            this.builds = null;
            return;
        }
        this.builds = new ArrayList<Build>(builds);
    }

    public ListBuildsResult withBuilds(Build ... builds) {
        if (this.builds == null) {
            this.setBuilds(new ArrayList<Build>(builds.length));
        }
        for (Build ele : builds) {
            this.builds.add(ele);
        }
        return this;
    }

    public ListBuildsResult withBuilds(Collection<Build> builds) {
        this.setBuilds(builds);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListBuildsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBuilds() != null) {
            sb.append("Builds: " + this.getBuilds() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBuildsResult)) {
            return false;
        }
        ListBuildsResult other = (ListBuildsResult)obj;
        if (other.getBuilds() == null ^ this.getBuilds() == null) {
            return false;
        }
        if (other.getBuilds() != null && !other.getBuilds().equals(this.getBuilds())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBuilds() == null ? 0 : this.getBuilds().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListBuildsResult clone() {
        try {
            return (ListBuildsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

