/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.elastictranscoder.model.ReadPipelineRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class ReadPipelineRequestMarshaller
implements Marshaller<Request<ReadPipelineRequest>, ReadPipelineRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ReadPipelineRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ReadPipelineRequest> marshall(ReadPipelineRequest readPipelineRequest) {
        if (readPipelineRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ReadPipelineRequest> request = new DefaultRequest<ReadPipelineRequest>(readPipelineRequest, "AmazonElasticTranscoder");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2012-09-25/pipelines/{Id}";
        uriResourcePath = uriResourcePath.replace("{Id}", readPipelineRequest.getId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(readPipelineRequest.getId()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

