/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.devicefarm.model.ScheduleRunRequest;
import com.amazonaws.services.devicefarm.model.transform.ScheduleRunConfigurationJsonMarshaller;
import com.amazonaws.services.devicefarm.model.transform.ScheduleRunTestJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ScheduleRunRequestMarshaller
implements Marshaller<Request<ScheduleRunRequest>, ScheduleRunRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ScheduleRunRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ScheduleRunRequest> marshall(ScheduleRunRequest scheduleRunRequest) {
        if (scheduleRunRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ScheduleRunRequest> request = new DefaultRequest<ScheduleRunRequest>(scheduleRunRequest, "AWSDeviceFarm");
        request.addHeader("X-Amz-Target", "DeviceFarm_20150623.ScheduleRun");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (scheduleRunRequest.getProjectArn() != null) {
                jsonGenerator.writeFieldName("projectArn").writeValue(scheduleRunRequest.getProjectArn());
            }
            if (scheduleRunRequest.getAppArn() != null) {
                jsonGenerator.writeFieldName("appArn").writeValue(scheduleRunRequest.getAppArn());
            }
            if (scheduleRunRequest.getDevicePoolArn() != null) {
                jsonGenerator.writeFieldName("devicePoolArn").writeValue(scheduleRunRequest.getDevicePoolArn());
            }
            if (scheduleRunRequest.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(scheduleRunRequest.getName());
            }
            if (scheduleRunRequest.getTest() != null) {
                jsonGenerator.writeFieldName("test");
                ScheduleRunTestJsonMarshaller.getInstance().marshall(scheduleRunRequest.getTest(), jsonGenerator);
            }
            if (scheduleRunRequest.getConfiguration() != null) {
                jsonGenerator.writeFieldName("configuration");
                ScheduleRunConfigurationJsonMarshaller.getInstance().marshall(scheduleRunRequest.getConfiguration(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

