/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.support.model.Communication;
import com.amazonaws.services.support.model.RecentCaseCommunications;
import com.amazonaws.services.support.model.transform.CommunicationJsonMarshaller;

public class RecentCaseCommunicationsJsonMarshaller {
    private static RecentCaseCommunicationsJsonMarshaller instance;

    public void marshall(RecentCaseCommunications recentCaseCommunications, StructuredJsonGenerator jsonGenerator) {
        if (recentCaseCommunications == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            SdkInternalList communicationsList = (SdkInternalList)recentCaseCommunications.getCommunications();
            if (!communicationsList.isEmpty() || !communicationsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("communications");
                jsonGenerator.writeStartArray();
                for (Communication communicationsListValue : communicationsList) {
                    if (communicationsListValue == null) continue;
                    CommunicationJsonMarshaller.getInstance().marshall(communicationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (recentCaseCommunications.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(recentCaseCommunications.getNextToken());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RecentCaseCommunicationsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RecentCaseCommunicationsJsonMarshaller();
        }
        return instance;
    }
}

