/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.sns.model.SetTopicAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SetTopicAttributesRequestMarshaller
implements Marshaller<Request<SetTopicAttributesRequest>, SetTopicAttributesRequest> {
    @Override
    public Request<SetTopicAttributesRequest> marshall(SetTopicAttributesRequest setTopicAttributesRequest) {
        if (setTopicAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SetTopicAttributesRequest> request = new DefaultRequest<SetTopicAttributesRequest>(setTopicAttributesRequest, "AmazonSNS");
        request.addParameter("Action", "SetTopicAttributes");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (setTopicAttributesRequest.getTopicArn() != null) {
            request.addParameter("TopicArn", StringUtils.fromString(setTopicAttributesRequest.getTopicArn()));
        }
        if (setTopicAttributesRequest.getAttributeName() != null) {
            request.addParameter("AttributeName", StringUtils.fromString(setTopicAttributesRequest.getAttributeName()));
        }
        if (setTopicAttributesRequest.getAttributeValue() != null) {
            request.addParameter("AttributeValue", StringUtils.fromString(setTopicAttributesRequest.getAttributeValue()));
        }
        return request;
    }
}

