/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.AssociationFilter;
import com.amazonaws.services.simplesystemsmanagement.model.ListAssociationsRequest;
import com.amazonaws.services.simplesystemsmanagement.model.transform.AssociationFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListAssociationsRequestMarshaller
implements Marshaller<Request<ListAssociationsRequest>, ListAssociationsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListAssociationsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListAssociationsRequest> marshall(ListAssociationsRequest listAssociationsRequest) {
        if (listAssociationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListAssociationsRequest> request = new DefaultRequest<ListAssociationsRequest>(listAssociationsRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.ListAssociations");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList associationFilterListList = (SdkInternalList)listAssociationsRequest.getAssociationFilterList();
            if (!associationFilterListList.isEmpty() || !associationFilterListList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("AssociationFilterList");
                jsonGenerator.writeStartArray();
                for (AssociationFilter associationFilterListListValue : associationFilterListList) {
                    if (associationFilterListListValue == null) continue;
                    AssociationFilterJsonMarshaller.getInstance().marshall(associationFilterListListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (listAssociationsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(listAssociationsRequest.getMaxResults());
            }
            if (listAssociationsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listAssociationsRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

