/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisanalytics.model.ApplicationDetail;
import com.amazonaws.services.kinesisanalytics.model.InputDescription;
import com.amazonaws.services.kinesisanalytics.model.OutputDescription;
import com.amazonaws.services.kinesisanalytics.model.ReferenceDataSourceDescription;
import com.amazonaws.services.kinesisanalytics.model.transform.InputDescriptionJsonMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.OutputDescriptionJsonMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.ReferenceDataSourceDescriptionJsonMarshaller;
import java.util.List;

public class ApplicationDetailJsonMarshaller {
    private static ApplicationDetailJsonMarshaller instance;

    public void marshall(ApplicationDetail applicationDetail, StructuredJsonGenerator jsonGenerator) {
        if (applicationDetail == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<ReferenceDataSourceDescription> list;
            List<OutputDescription> outputDescriptionsList;
            List<InputDescription> inputDescriptionsList;
            jsonGenerator.writeStartObject();
            if (applicationDetail.getApplicationName() != null) {
                jsonGenerator.writeFieldName("ApplicationName").writeValue(applicationDetail.getApplicationName());
            }
            if (applicationDetail.getApplicationDescription() != null) {
                jsonGenerator.writeFieldName("ApplicationDescription").writeValue(applicationDetail.getApplicationDescription());
            }
            if (applicationDetail.getApplicationARN() != null) {
                jsonGenerator.writeFieldName("ApplicationARN").writeValue(applicationDetail.getApplicationARN());
            }
            if (applicationDetail.getApplicationStatus() != null) {
                jsonGenerator.writeFieldName("ApplicationStatus").writeValue(applicationDetail.getApplicationStatus());
            }
            if (applicationDetail.getCreateTimestamp() != null) {
                jsonGenerator.writeFieldName("CreateTimestamp").writeValue(applicationDetail.getCreateTimestamp());
            }
            if (applicationDetail.getLastUpdateTimestamp() != null) {
                jsonGenerator.writeFieldName("LastUpdateTimestamp").writeValue(applicationDetail.getLastUpdateTimestamp());
            }
            if ((inputDescriptionsList = applicationDetail.getInputDescriptions()) != null) {
                jsonGenerator.writeFieldName("InputDescriptions");
                jsonGenerator.writeStartArray();
                for (InputDescription inputDescription : inputDescriptionsList) {
                    if (inputDescription == null) continue;
                    InputDescriptionJsonMarshaller.getInstance().marshall(inputDescription, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((outputDescriptionsList = applicationDetail.getOutputDescriptions()) != null) {
                jsonGenerator.writeFieldName("OutputDescriptions");
                jsonGenerator.writeStartArray();
                for (OutputDescription outputDescriptionsListValue : outputDescriptionsList) {
                    if (outputDescriptionsListValue == null) continue;
                    OutputDescriptionJsonMarshaller.getInstance().marshall(outputDescriptionsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list = applicationDetail.getReferenceDataSourceDescriptions()) != null) {
                jsonGenerator.writeFieldName("ReferenceDataSourceDescriptions");
                jsonGenerator.writeStartArray();
                for (ReferenceDataSourceDescription referenceDataSourceDescriptionsListValue : list) {
                    if (referenceDataSourceDescriptionsListValue == null) continue;
                    ReferenceDataSourceDescriptionJsonMarshaller.getInstance().marshall(referenceDataSourceDescriptionsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (applicationDetail.getApplicationCode() != null) {
                jsonGenerator.writeFieldName("ApplicationCode").writeValue(applicationDetail.getApplicationCode());
            }
            if (applicationDetail.getApplicationVersionId() != null) {
                jsonGenerator.writeFieldName("ApplicationVersionId").writeValue(applicationDetail.getApplicationVersionId());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ApplicationDetailJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ApplicationDetailJsonMarshaller();
        }
        return instance;
    }
}

