/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iot.model.ListCertificatesByCARequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class ListCertificatesByCARequestMarshaller
implements Marshaller<Request<ListCertificatesByCARequest>, ListCertificatesByCARequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListCertificatesByCARequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListCertificatesByCARequest> marshall(ListCertificatesByCARequest listCertificatesByCARequest) {
        if (listCertificatesByCARequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListCertificatesByCARequest> request = new DefaultRequest<ListCertificatesByCARequest>(listCertificatesByCARequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/certificates-by-ca/{caCertificateId}";
        uriResourcePath = uriResourcePath.replace("{caCertificateId}", listCertificatesByCARequest.getCaCertificateId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(listCertificatesByCARequest.getCaCertificateId()), false) : "");
        request.setResourcePath(uriResourcePath);
        if (listCertificatesByCARequest.getPageSize() != null) {
            request.addParameter("pageSize", StringUtils.fromInteger(listCertificatesByCARequest.getPageSize()));
        }
        if (listCertificatesByCARequest.getMarker() != null) {
            request.addParameter("marker", StringUtils.fromString(listCertificatesByCARequest.getMarker()));
        }
        if (listCertificatesByCARequest.getAscendingOrder() != null) {
            request.addParameter("isAscendingOrder", StringUtils.fromBoolean(listCertificatesByCARequest.getAscendingOrder()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

