/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticmapreduce.model.StepStatus;
import com.amazonaws.services.elasticmapreduce.model.transform.FailureDetailsJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.StepStateChangeReasonJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.StepTimelineJsonMarshaller;

public class StepStatusJsonMarshaller {
    private static StepStatusJsonMarshaller instance;

    public void marshall(StepStatus stepStatus, StructuredJsonGenerator jsonGenerator) {
        if (stepStatus == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (stepStatus.getState() != null) {
                jsonGenerator.writeFieldName("State").writeValue(stepStatus.getState());
            }
            if (stepStatus.getStateChangeReason() != null) {
                jsonGenerator.writeFieldName("StateChangeReason");
                StepStateChangeReasonJsonMarshaller.getInstance().marshall(stepStatus.getStateChangeReason(), jsonGenerator);
            }
            if (stepStatus.getFailureDetails() != null) {
                jsonGenerator.writeFieldName("FailureDetails");
                FailureDetailsJsonMarshaller.getInstance().marshall(stepStatus.getFailureDetails(), jsonGenerator);
            }
            if (stepStatus.getTimeline() != null) {
                jsonGenerator.writeFieldName("Timeline");
                StepTimelineJsonMarshaller.getInstance().marshall(stepStatus.getTimeline(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StepStatusJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StepStatusJsonMarshaller();
        }
        return instance;
    }
}

