/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.ApplicationDescription;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeApplicationsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<ApplicationDescription> applications;

    public List<ApplicationDescription> getApplications() {
        if (this.applications == null) {
            this.applications = new SdkInternalList();
        }
        return this.applications;
    }

    public void setApplications(Collection<ApplicationDescription> applications) {
        if (applications == null) {
            this.applications = null;
            return;
        }
        this.applications = new SdkInternalList<ApplicationDescription>(applications);
    }

    public DescribeApplicationsResult withApplications(ApplicationDescription ... applications) {
        if (this.applications == null) {
            this.setApplications(new SdkInternalList<ApplicationDescription>(applications.length));
        }
        for (ApplicationDescription ele : applications) {
            this.applications.add(ele);
        }
        return this;
    }

    public DescribeApplicationsResult withApplications(Collection<ApplicationDescription> applications) {
        this.setApplications(applications);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplications() != null) {
            sb.append("Applications: " + this.getApplications());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationsResult)) {
            return false;
        }
        DescribeApplicationsResult other = (DescribeApplicationsResult)obj;
        if (other.getApplications() == null ^ this.getApplications() == null) {
            return false;
        }
        return other.getApplications() == null || other.getApplications().equals(this.getApplications());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplications() == null ? 0 : this.getApplications().hashCode());
        return hashCode;
    }

    public DescribeApplicationsResult clone() {
        try {
            return (DescribeApplicationsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

