/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directory.model.RestoreFromSnapshotRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class RestoreFromSnapshotRequestMarshaller
implements Marshaller<Request<RestoreFromSnapshotRequest>, RestoreFromSnapshotRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public RestoreFromSnapshotRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<RestoreFromSnapshotRequest> marshall(RestoreFromSnapshotRequest restoreFromSnapshotRequest) {
        if (restoreFromSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RestoreFromSnapshotRequest> request = new DefaultRequest<RestoreFromSnapshotRequest>(restoreFromSnapshotRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.RestoreFromSnapshot");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (restoreFromSnapshotRequest.getSnapshotId() != null) {
                jsonGenerator.writeFieldName("SnapshotId").writeValue(restoreFromSnapshotRequest.getSnapshotId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

