/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.datapipeline.model.SetStatusRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class SetStatusRequestMarshaller
implements Marshaller<Request<SetStatusRequest>, SetStatusRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public SetStatusRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<SetStatusRequest> marshall(SetStatusRequest setStatusRequest) {
        if (setStatusRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SetStatusRequest> request = new DefaultRequest<SetStatusRequest>(setStatusRequest, "DataPipeline");
        request.addHeader("X-Amz-Target", "DataPipeline.SetStatus");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList objectIdsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (setStatusRequest.getPipelineId() != null) {
                jsonGenerator.writeFieldName("pipelineId").writeValue(setStatusRequest.getPipelineId());
            }
            if (!(objectIdsList = (SdkInternalList)setStatusRequest.getObjectIds()).isEmpty() || !objectIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("objectIds");
                jsonGenerator.writeStartArray();
                for (String objectIdsListValue : objectIdsList) {
                    if (objectIdsListValue == null) continue;
                    jsonGenerator.writeValue(objectIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (setStatusRequest.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(setStatusRequest.getStatus());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

