/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codecommit.model.BatchGetRepositoriesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class BatchGetRepositoriesRequestMarshaller
implements Marshaller<Request<BatchGetRepositoriesRequest>, BatchGetRepositoriesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public BatchGetRepositoriesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<BatchGetRepositoriesRequest> marshall(BatchGetRepositoriesRequest batchGetRepositoriesRequest) {
        if (batchGetRepositoriesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<BatchGetRepositoriesRequest> request = new DefaultRequest<BatchGetRepositoriesRequest>(batchGetRepositoriesRequest, "AWSCodeCommit");
        request.addHeader("X-Amz-Target", "CodeCommit_20150413.BatchGetRepositories");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> repositoryNamesList = batchGetRepositoriesRequest.getRepositoryNames();
            if (repositoryNamesList != null) {
                jsonGenerator.writeFieldName("repositoryNames");
                jsonGenerator.writeStartArray();
                for (String repositoryNamesListValue : repositoryNamesList) {
                    if (repositoryNamesListValue == null) continue;
                    jsonGenerator.writeValue(repositoryNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

