/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.budgets.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.budgets.model.DescribeNotificationsForBudgetRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeNotificationsForBudgetRequestMarshaller
implements Marshaller<Request<DescribeNotificationsForBudgetRequest>, DescribeNotificationsForBudgetRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeNotificationsForBudgetRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeNotificationsForBudgetRequest> marshall(DescribeNotificationsForBudgetRequest describeNotificationsForBudgetRequest) {
        if (describeNotificationsForBudgetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeNotificationsForBudgetRequest> request = new DefaultRequest<DescribeNotificationsForBudgetRequest>(describeNotificationsForBudgetRequest, "AWSBudgets");
        request.addHeader("X-Amz-Target", "AWSBudgetServiceGateway.DescribeNotificationsForBudget");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeNotificationsForBudgetRequest.getAccountId() != null) {
                jsonGenerator.writeFieldName("AccountId").writeValue(describeNotificationsForBudgetRequest.getAccountId());
            }
            if (describeNotificationsForBudgetRequest.getBudgetName() != null) {
                jsonGenerator.writeFieldName("BudgetName").writeValue(describeNotificationsForBudgetRequest.getBudgetName());
            }
            if (describeNotificationsForBudgetRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(describeNotificationsForBudgetRequest.getMaxResults());
            }
            if (describeNotificationsForBudgetRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeNotificationsForBudgetRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

