/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.GetGeoLocationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetGeoLocationRequestMarshaller
implements Marshaller<Request<GetGeoLocationRequest>, GetGeoLocationRequest> {
    @Override
    public Request<GetGeoLocationRequest> marshall(GetGeoLocationRequest getGeoLocationRequest) {
        if (getGeoLocationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetGeoLocationRequest> request = new DefaultRequest<GetGeoLocationRequest>(getGeoLocationRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/geolocation";
        request.setResourcePath(uriResourcePath);
        if (getGeoLocationRequest.getContinentCode() != null) {
            request.addParameter("continentcode", StringUtils.fromString(getGeoLocationRequest.getContinentCode()));
        }
        if (getGeoLocationRequest.getCountryCode() != null) {
            request.addParameter("countrycode", StringUtils.fromString(getGeoLocationRequest.getCountryCode()));
        }
        if (getGeoLocationRequest.getSubdivisionCode() != null) {
            request.addParameter("subdivisioncode", StringUtils.fromString(getGeoLocationRequest.getSubdivisionCode()));
        }
        return request;
    }
}

