/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworks.model.SslConfiguration;

public class SslConfigurationJsonMarshaller {
    private static SslConfigurationJsonMarshaller instance;

    public void marshall(SslConfiguration sslConfiguration, StructuredJsonGenerator jsonGenerator) {
        if (sslConfiguration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (sslConfiguration.getCertificate() != null) {
                jsonGenerator.writeFieldName("Certificate").writeValue(sslConfiguration.getCertificate());
            }
            if (sslConfiguration.getPrivateKey() != null) {
                jsonGenerator.writeFieldName("PrivateKey").writeValue(sslConfiguration.getPrivateKey());
            }
            if (sslConfiguration.getChain() != null) {
                jsonGenerator.writeFieldName("Chain").writeValue(sslConfiguration.getChain());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SslConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SslConfigurationJsonMarshaller();
        }
        return instance;
    }
}

