/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesis.model.GetShardIteratorRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class GetShardIteratorRequestMarshaller
implements Marshaller<Request<GetShardIteratorRequest>, GetShardIteratorRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetShardIteratorRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetShardIteratorRequest> marshall(GetShardIteratorRequest getShardIteratorRequest) {
        if (getShardIteratorRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetShardIteratorRequest> request = new DefaultRequest<GetShardIteratorRequest>(getShardIteratorRequest, "AmazonKinesis");
        request.addHeader("X-Amz-Target", "Kinesis_20131202.GetShardIterator");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getShardIteratorRequest.getStreamName() != null) {
                jsonGenerator.writeFieldName("StreamName").writeValue(getShardIteratorRequest.getStreamName());
            }
            if (getShardIteratorRequest.getShardId() != null) {
                jsonGenerator.writeFieldName("ShardId").writeValue(getShardIteratorRequest.getShardId());
            }
            if (getShardIteratorRequest.getShardIteratorType() != null) {
                jsonGenerator.writeFieldName("ShardIteratorType").writeValue(getShardIteratorRequest.getShardIteratorType());
            }
            if (getShardIteratorRequest.getStartingSequenceNumber() != null) {
                jsonGenerator.writeFieldName("StartingSequenceNumber").writeValue(getShardIteratorRequest.getStartingSequenceNumber());
            }
            if (getShardIteratorRequest.getTimestamp() != null) {
                jsonGenerator.writeFieldName("Timestamp").writeValue(getShardIteratorRequest.getTimestamp());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

