/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iot.model.DescribeCertificateRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DescribeCertificateRequestMarshaller
implements Marshaller<Request<DescribeCertificateRequest>, DescribeCertificateRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeCertificateRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeCertificateRequest> marshall(DescribeCertificateRequest describeCertificateRequest) {
        if (describeCertificateRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeCertificateRequest> request = new DefaultRequest<DescribeCertificateRequest>(describeCertificateRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/certificates/{certificateId}";
        uriResourcePath = uriResourcePath.replace("{certificateId}", describeCertificateRequest.getCertificateId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(describeCertificateRequest.getCertificateId()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

