/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.elasticache.AmazonElastiCache;
import com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheClustersResult;
import com.amazonaws.services.elasticache.model.DescribeReplicationGroupsRequest;
import com.amazonaws.services.elasticache.model.DescribeReplicationGroupsResult;
import com.amazonaws.services.elasticache.waiters.CacheClusterAvailable;
import com.amazonaws.services.elasticache.waiters.CacheClusterDeleted;
import com.amazonaws.services.elasticache.waiters.DescribeCacheClustersFunction;
import com.amazonaws.services.elasticache.waiters.DescribeReplicationGroupsFunction;
import com.amazonaws.services.elasticache.waiters.ReplicationGroupAvailable;
import com.amazonaws.services.elasticache.waiters.ReplicationGroupDeleted;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AmazonElastiCacheWaiters {
    private final AmazonElastiCache client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonElastiCacheWaiters(AmazonElastiCache client) {
        this.client = client;
    }

    public Waiter<DescribeCacheClustersRequest> cacheClusterDeleted() {
        return new WaiterBuilder<DescribeCacheClustersRequest, DescribeCacheClustersResult>().withSdkFunction(new DescribeCacheClustersFunction(this.client)).withAcceptors(new CacheClusterDeleted.IsDeletedMatcher(), new CacheClusterDeleted.IsCacheClusterNotFoundMatcher(), new CacheClusterDeleted.IsAvailableMatcher(), new CacheClusterDeleted.IsCreatingMatcher(), new CacheClusterDeleted.IsIncompatiblenetworkMatcher(), new CacheClusterDeleted.IsModifyingMatcher(), new CacheClusterDeleted.IsRestorefailedMatcher(), new CacheClusterDeleted.IsSnapshottingMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(40), new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeReplicationGroupsRequest> replicationGroupAvailable() {
        return new WaiterBuilder<DescribeReplicationGroupsRequest, DescribeReplicationGroupsResult>().withSdkFunction(new DescribeReplicationGroupsFunction(this.client)).withAcceptors(new ReplicationGroupAvailable.IsAvailableMatcher(), new ReplicationGroupAvailable.IsDeletedMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(40), new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeCacheClustersRequest> cacheClusterAvailable() {
        return new WaiterBuilder<DescribeCacheClustersRequest, DescribeCacheClustersResult>().withSdkFunction(new DescribeCacheClustersFunction(this.client)).withAcceptors(new CacheClusterAvailable.IsAvailableMatcher(), new CacheClusterAvailable.IsDeletedMatcher(), new CacheClusterAvailable.IsDeletingMatcher(), new CacheClusterAvailable.IsIncompatiblenetworkMatcher(), new CacheClusterAvailable.IsRestorefailedMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(40), new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeReplicationGroupsRequest> replicationGroupDeleted() {
        return new WaiterBuilder<DescribeReplicationGroupsRequest, DescribeReplicationGroupsResult>().withSdkFunction(new DescribeReplicationGroupsFunction(this.client)).withAcceptors(new ReplicationGroupDeleted.IsDeletedMatcher(), new ReplicationGroupDeleted.IsAvailableMatcher(), new ReplicationGroupDeleted.IsReplicationGroupNotFoundFaultMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(40), new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }
}

