/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeHostsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeHostsRequestMarshaller
implements Marshaller<Request<DescribeHostsRequest>, DescribeHostsRequest> {
    @Override
    public Request<DescribeHostsRequest> marshall(DescribeHostsRequest describeHostsRequest) {
        SdkInternalList filterList;
        if (describeHostsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeHostsRequest> request = new DefaultRequest<DescribeHostsRequest>(describeHostsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeHosts");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList hostIdsList = (SdkInternalList)describeHostsRequest.getHostIds();
        if (!hostIdsList.isEmpty() || !hostIdsList.isAutoConstruct()) {
            int hostIdsListIndex = 1;
            for (String hostIdsListValue : hostIdsList) {
                if (hostIdsListValue != null) {
                    request.addParameter("HostId." + hostIdsListIndex, StringUtils.fromString(hostIdsListValue));
                }
                ++hostIdsListIndex;
            }
        }
        if (describeHostsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeHostsRequest.getNextToken()));
        }
        if (describeHostsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeHostsRequest.getMaxResults()));
        }
        if (!(filterList = (SdkInternalList)describeHostsRequest.getFilter()).isEmpty() || !filterList.isAutoConstruct()) {
            int filterListIndex = 1;
            for (Filter filterListValue : filterList) {
                SdkInternalList valuesList;
                if (filterListValue.getName() != null) {
                    request.addParameter("Filter." + filterListIndex + ".Name", StringUtils.fromString(filterListValue.getName()));
                }
                if (!(valuesList = (SdkInternalList)filterListValue.getValues()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filter." + filterListIndex + ".Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filterListIndex;
            }
        }
        return request;
    }
}

