/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeConversionTasksRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeConversionTasksRequestMarshaller
implements Marshaller<Request<DescribeConversionTasksRequest>, DescribeConversionTasksRequest> {
    @Override
    public Request<DescribeConversionTasksRequest> marshall(DescribeConversionTasksRequest describeConversionTasksRequest) {
        if (describeConversionTasksRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeConversionTasksRequest> request = new DefaultRequest<DescribeConversionTasksRequest>(describeConversionTasksRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeConversionTasks");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList conversionTaskIdsList = (SdkInternalList)describeConversionTasksRequest.getConversionTaskIds();
        if (!conversionTaskIdsList.isEmpty() || !conversionTaskIdsList.isAutoConstruct()) {
            int conversionTaskIdsListIndex = 1;
            for (String conversionTaskIdsListValue : conversionTaskIdsList) {
                if (conversionTaskIdsListValue != null) {
                    request.addParameter("ConversionTaskId." + conversionTaskIdsListIndex, StringUtils.fromString(conversionTaskIdsListValue));
                }
                ++conversionTaskIdsListIndex;
            }
        }
        return request;
    }
}

