/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.cognitosync.model.DescribeIdentityUsageRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DescribeIdentityUsageRequestMarshaller
implements Marshaller<Request<DescribeIdentityUsageRequest>, DescribeIdentityUsageRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeIdentityUsageRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeIdentityUsageRequest> marshall(DescribeIdentityUsageRequest describeIdentityUsageRequest) {
        if (describeIdentityUsageRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeIdentityUsageRequest> request = new DefaultRequest<DescribeIdentityUsageRequest>(describeIdentityUsageRequest, "AmazonCognitoSync");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/identities/{IdentityId}";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", describeIdentityUsageRequest.getIdentityPoolId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(describeIdentityUsageRequest.getIdentityPoolId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{IdentityId}", describeIdentityUsageRequest.getIdentityId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(describeIdentityUsageRequest.getIdentityId()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

