/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeScalingActivitiesRequestMarshaller
implements Marshaller<Request<DescribeScalingActivitiesRequest>, DescribeScalingActivitiesRequest> {
    @Override
    public Request<DescribeScalingActivitiesRequest> marshall(DescribeScalingActivitiesRequest describeScalingActivitiesRequest) {
        if (describeScalingActivitiesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeScalingActivitiesRequest> request = new DefaultRequest<DescribeScalingActivitiesRequest>(describeScalingActivitiesRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DescribeScalingActivities");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList activityIdsList = (SdkInternalList)describeScalingActivitiesRequest.getActivityIds();
        if (!activityIdsList.isEmpty() || !activityIdsList.isAutoConstruct()) {
            int activityIdsListIndex = 1;
            for (String activityIdsListValue : activityIdsList) {
                if (activityIdsListValue != null) {
                    request.addParameter("ActivityIds.member." + activityIdsListIndex, StringUtils.fromString(activityIdsListValue));
                }
                ++activityIdsListIndex;
            }
        }
        if (describeScalingActivitiesRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(describeScalingActivitiesRequest.getAutoScalingGroupName()));
        }
        if (describeScalingActivitiesRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeScalingActivitiesRequest.getMaxRecords()));
        }
        if (describeScalingActivitiesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeScalingActivitiesRequest.getNextToken()));
        }
        return request;
    }
}

