/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.annotation.SdkTestInternalApi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.HttpClientConnectionManager;

public final class IdleConnectionReaper
extends Thread {
    static final Log log = LogFactory.getLog(IdleConnectionReaper.class);
    private static final int PERIOD_MILLISECONDS = 60000;
    private static final ArrayList<HttpClientConnectionManager> connectionManagers = new ArrayList();
    private static IdleConnectionReaper instance;
    private volatile boolean shuttingDown;

    private IdleConnectionReaper() {
        super("java-sdk-http-connection-reaper");
        this.setDaemon(true);
    }

    public static synchronized boolean registerConnectionManager(HttpClientConnectionManager connectionManager) {
        if (instance == null) {
            instance = new IdleConnectionReaper();
            instance.start();
        }
        return connectionManagers.add(connectionManager);
    }

    public static synchronized boolean removeConnectionManager(HttpClientConnectionManager connectionManager) {
        boolean b = connectionManagers.remove(connectionManager);
        if (connectionManagers.isEmpty()) {
            IdleConnectionReaper.shutdown();
        }
        return b;
    }

    @SdkTestInternalApi
    public static synchronized List<HttpClientConnectionManager> getRegisteredConnectionManagers() {
        return Collections.unmodifiableList(connectionManagers);
    }

    public static synchronized boolean shutdown() {
        if (instance != null) {
            instance.markShuttingDown();
            instance.interrupt();
            connectionManagers.clear();
            instance = null;
            return true;
        }
        return false;
    }

    static synchronized int size() {
        return connectionManagers.size();
    }

    private void markShuttingDown() {
        this.shuttingDown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        block6: while (true) {
            if (this.shuttingDown) {
                log.debug((Object)"Shutting down reaper thread.");
                return;
            }
            try {
                Thread.sleep(60000L);
                List connectionManagers = null;
                Object object = IdleConnectionReaper.class;
                // MONITORENTER : com.amazonaws.http.IdleConnectionReaper.class
                connectionManagers = (List)IdleConnectionReaper.connectionManagers.clone();
                // MONITOREXIT : object
                object = connectionManagers.iterator();
                while (true) {
                    if (!object.hasNext()) continue block6;
                    HttpClientConnectionManager connectionManager = (HttpClientConnectionManager)object.next();
                    try {
                        connectionManager.closeIdleConnections(60L, TimeUnit.SECONDS);
                    }
                    catch (Exception t) {
                        log.warn((Object)"Unable to close idle connections", (Throwable)t);
                    }
                }
            }
            catch (Throwable t) {
                log.debug((Object)"Reaper thread: ", t);
                continue;
            }
            break;
        }
    }
}

