/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iot.model.AcceptCertificateTransferRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class AcceptCertificateTransferRequestMarshaller
implements Marshaller<Request<AcceptCertificateTransferRequest>, AcceptCertificateTransferRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public AcceptCertificateTransferRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<AcceptCertificateTransferRequest> marshall(AcceptCertificateTransferRequest acceptCertificateTransferRequest) {
        if (acceptCertificateTransferRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AcceptCertificateTransferRequest> request = new DefaultRequest<AcceptCertificateTransferRequest>(acceptCertificateTransferRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.PATCH);
        String uriResourcePath = "/accept-certificate-transfer/{certificateId}";
        uriResourcePath = uriResourcePath.replace("{certificateId}", acceptCertificateTransferRequest.getCertificateId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(acceptCertificateTransferRequest.getCertificateId()), false) : "");
        request.setResourcePath(uriResourcePath);
        if (acceptCertificateTransferRequest.getSetAsActive() != null) {
            request.addParameter("setAsActive", StringUtils.fromBoolean(acceptCertificateTransferRequest.getSetAsActive()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

