/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elastictranscoder.model.Permission;
import com.amazonaws.services.elastictranscoder.model.PipelineOutputConfig;
import com.amazonaws.services.elastictranscoder.model.transform.PermissionJsonMarshaller;

public class PipelineOutputConfigJsonMarshaller {
    private static PipelineOutputConfigJsonMarshaller instance;

    public void marshall(PipelineOutputConfig pipelineOutputConfig, StructuredJsonGenerator jsonGenerator) {
        if (pipelineOutputConfig == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList permissionsList;
            jsonGenerator.writeStartObject();
            if (pipelineOutputConfig.getBucket() != null) {
                jsonGenerator.writeFieldName("Bucket").writeValue(pipelineOutputConfig.getBucket());
            }
            if (pipelineOutputConfig.getStorageClass() != null) {
                jsonGenerator.writeFieldName("StorageClass").writeValue(pipelineOutputConfig.getStorageClass());
            }
            if (!(permissionsList = (SdkInternalList)pipelineOutputConfig.getPermissions()).isEmpty() || !permissionsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Permissions");
                jsonGenerator.writeStartArray();
                for (Permission permissionsListValue : permissionsList) {
                    if (permissionsListValue == null) continue;
                    PermissionJsonMarshaller.getInstance().marshall(permissionsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PipelineOutputConfigJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PipelineOutputConfigJsonMarshaller();
        }
        return instance;
    }
}

