/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.services.elasticbeanstalk.model.CPUUtilization;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class CPUUtilizationStaxUnmarshaller
implements Unmarshaller<CPUUtilization, StaxUnmarshallerContext> {
    private static CPUUtilizationStaxUnmarshaller instance;

    @Override
    public CPUUtilization unmarshall(StaxUnmarshallerContext context) throws Exception {
        CPUUtilization cPUUtilization = new CPUUtilization();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return cPUUtilization;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("User", targetDepth)) {
                    cPUUtilization.setUser(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Nice", targetDepth)) {
                    cPUUtilization.setNice(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("System", targetDepth)) {
                    cPUUtilization.setSystem(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Idle", targetDepth)) {
                    cPUUtilization.setIdle(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IOWait", targetDepth)) {
                    cPUUtilization.setIOWait(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IRQ", targetDepth)) {
                    cPUUtilization.setIRQ(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("SoftIRQ", targetDepth)) continue;
                cPUUtilization.setSoftIRQ(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return cPUUtilization;
    }

    public static CPUUtilizationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CPUUtilizationStaxUnmarshaller();
        }
        return instance;
    }
}

