/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.handlers.AbstractRequestHandler;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsResult;
import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.ImportKeyPairRequest;
import com.amazonaws.services.ec2.model.LaunchSpecification;
import com.amazonaws.services.ec2.model.ModifyReservedInstancesRequest;
import com.amazonaws.services.ec2.model.RequestSpotInstancesRequest;
import com.amazonaws.services.ec2.model.RequestSpotInstancesResult;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesResult;
import com.amazonaws.services.ec2.model.SpotInstanceRequest;
import com.amazonaws.util.Base64;
import com.amazonaws.util.TimingInfo;
import java.util.ArrayList;
import java.util.UUID;

public class EC2RequestHandler
extends AbstractRequestHandler {
    @Override
    public void beforeRequest(Request<?> request) {
        ModifyReservedInstancesRequest modifyReservedInstancesRequest;
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest instanceof ImportKeyPairRequest) {
            ImportKeyPairRequest importKeyPairRequest = (ImportKeyPairRequest)originalRequest;
            String publicKeyMaterial = importKeyPairRequest.getPublicKeyMaterial();
            String encodedKeyMaterial = Base64.encodeAsString(publicKeyMaterial.getBytes());
            request.addParameter("PublicKeyMaterial", encodedKeyMaterial);
        } else if (originalRequest instanceof RequestSpotInstancesRequest) {
            RequestSpotInstancesRequest requestSpotInstancesRequest = (RequestSpotInstancesRequest)originalRequest;
            int groupNameCount = 1;
            for (String string : requestSpotInstancesRequest.getLaunchSpecification().getSecurityGroups()) {
                request.addParameter("LaunchSpecification.SecurityGroup." + groupNameCount++, string);
            }
            int groupIdCount = 1;
            for (GroupIdentifier group : requestSpotInstancesRequest.getLaunchSpecification().getAllSecurityGroups()) {
                if (group.getGroupId() != null) {
                    request.addParameter("LaunchSpecification.SecurityGroupId." + groupIdCount++, group.getGroupId());
                }
                if (group.getGroupName() == null) continue;
                request.addParameter("LaunchSpecification.SecurityGroup." + groupNameCount++, group.getGroupName());
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String parameter : request.getParameters().keySet()) {
                if (!parameter.startsWith("LaunchSpecification.GroupSet.")) continue;
                arrayList.add(parameter);
            }
            for (String key : arrayList) {
                request.getParameters().remove(key);
            }
        } else if (originalRequest instanceof RunInstancesRequest) {
            RunInstancesRequest runInstancesRequest = (RunInstancesRequest)originalRequest;
            if (runInstancesRequest.getClientToken() == null) {
                request.addParameter("ClientToken", UUID.randomUUID().toString());
            }
        } else if (originalRequest instanceof ModifyReservedInstancesRequest && (modifyReservedInstancesRequest = (ModifyReservedInstancesRequest)originalRequest).getClientToken() == null) {
            request.addParameter("ClientToken", UUID.randomUUID().toString());
        }
    }

    @Override
    public void afterResponse(Request<?> request, Object response, TimingInfo timingInfo) {
        if (response instanceof DescribeSpotInstanceRequestsResult) {
            DescribeSpotInstanceRequestsResult result = (DescribeSpotInstanceRequestsResult)response;
            for (SpotInstanceRequest spotInstanceRequest : result.getSpotInstanceRequests()) {
                LaunchSpecification launchSpecification = spotInstanceRequest.getLaunchSpecification();
                this.populateLaunchSpecificationSecurityGroupNames(launchSpecification);
            }
        } else if (response instanceof RequestSpotInstancesResult) {
            RequestSpotInstancesResult result = (RequestSpotInstancesResult)response;
            for (SpotInstanceRequest spotInstanceRequest : result.getSpotInstanceRequests()) {
                LaunchSpecification launchSpecification = spotInstanceRequest.getLaunchSpecification();
                this.populateLaunchSpecificationSecurityGroupNames(launchSpecification);
            }
        } else if (response instanceof DescribeInstancesResult) {
            DescribeInstancesResult result = (DescribeInstancesResult)response;
            for (Reservation reservation : result.getReservations()) {
                this.populateReservationSecurityGroupNames(reservation);
            }
        } else if (response instanceof RunInstancesResult) {
            RunInstancesResult result = (RunInstancesResult)response;
            this.populateReservationSecurityGroupNames(result.getReservation());
        }
    }

    private void populateReservationSecurityGroupNames(Reservation reservation) {
        ArrayList<String> groupNames = new ArrayList<String>();
        for (GroupIdentifier group : reservation.getGroups()) {
            groupNames.add(group.getGroupName());
        }
        reservation.setGroupNames(groupNames);
    }

    private void populateLaunchSpecificationSecurityGroupNames(LaunchSpecification launchSpecification) {
        ArrayList<String> groupNames = new ArrayList<String>();
        for (GroupIdentifier group : launchSpecification.getAllSecurityGroups()) {
            groupNames.add(group.getGroupName());
        }
        launchSpecification.setSecurityGroups(groupNames);
    }
}

