/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisanalytics.model.InputDescription;
import com.amazonaws.services.kinesisanalytics.model.transform.InputParallelismJsonMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.InputStartingPositionConfigurationJsonMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.KinesisFirehoseInputDescriptionJsonMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.KinesisStreamsInputDescriptionJsonMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.SourceSchemaJsonMarshaller;
import java.util.List;

public class InputDescriptionJsonMarshaller {
    private static InputDescriptionJsonMarshaller instance;

    public void marshall(InputDescription inputDescription, StructuredJsonGenerator jsonGenerator) {
        if (inputDescription == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> inAppStreamNamesList;
            jsonGenerator.writeStartObject();
            if (inputDescription.getInputId() != null) {
                jsonGenerator.writeFieldName("InputId").writeValue(inputDescription.getInputId());
            }
            if (inputDescription.getNamePrefix() != null) {
                jsonGenerator.writeFieldName("NamePrefix").writeValue(inputDescription.getNamePrefix());
            }
            if ((inAppStreamNamesList = inputDescription.getInAppStreamNames()) != null) {
                jsonGenerator.writeFieldName("InAppStreamNames");
                jsonGenerator.writeStartArray();
                for (String inAppStreamNamesListValue : inAppStreamNamesList) {
                    if (inAppStreamNamesListValue == null) continue;
                    jsonGenerator.writeValue(inAppStreamNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (inputDescription.getKinesisStreamsInputDescription() != null) {
                jsonGenerator.writeFieldName("KinesisStreamsInputDescription");
                KinesisStreamsInputDescriptionJsonMarshaller.getInstance().marshall(inputDescription.getKinesisStreamsInputDescription(), jsonGenerator);
            }
            if (inputDescription.getKinesisFirehoseInputDescription() != null) {
                jsonGenerator.writeFieldName("KinesisFirehoseInputDescription");
                KinesisFirehoseInputDescriptionJsonMarshaller.getInstance().marshall(inputDescription.getKinesisFirehoseInputDescription(), jsonGenerator);
            }
            if (inputDescription.getInputSchema() != null) {
                jsonGenerator.writeFieldName("InputSchema");
                SourceSchemaJsonMarshaller.getInstance().marshall(inputDescription.getInputSchema(), jsonGenerator);
            }
            if (inputDescription.getInputParallelism() != null) {
                jsonGenerator.writeFieldName("InputParallelism");
                InputParallelismJsonMarshaller.getInstance().marshall(inputDescription.getInputParallelism(), jsonGenerator);
            }
            if (inputDescription.getInputStartingPositionConfiguration() != null) {
                jsonGenerator.writeFieldName("InputStartingPositionConfiguration");
                InputStartingPositionConfigurationJsonMarshaller.getInstance().marshall(inputDescription.getInputStartingPositionConfiguration(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static InputDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new InputDescriptionJsonMarshaller();
        }
        return instance;
    }
}

