/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.config.model.StartConfigRulesEvaluationRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class StartConfigRulesEvaluationRequestMarshaller
implements Marshaller<Request<StartConfigRulesEvaluationRequest>, StartConfigRulesEvaluationRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public StartConfigRulesEvaluationRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<StartConfigRulesEvaluationRequest> marshall(StartConfigRulesEvaluationRequest startConfigRulesEvaluationRequest) {
        if (startConfigRulesEvaluationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<StartConfigRulesEvaluationRequest> request = new DefaultRequest<StartConfigRulesEvaluationRequest>(startConfigRulesEvaluationRequest, "AmazonConfig");
        request.addHeader("X-Amz-Target", "StarlingDoveService.StartConfigRulesEvaluation");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList configRuleNamesList = (SdkInternalList)startConfigRulesEvaluationRequest.getConfigRuleNames();
            if (!configRuleNamesList.isEmpty() || !configRuleNamesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ConfigRuleNames");
                jsonGenerator.writeStartArray();
                for (String configRuleNamesListValue : configRuleNamesList) {
                    if (configRuleNamesListValue == null) continue;
                    jsonGenerator.writeValue(configRuleNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

