/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codedeploy.model.RegisterApplicationRevisionRequest;
import com.amazonaws.services.codedeploy.model.transform.RevisionLocationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class RegisterApplicationRevisionRequestMarshaller
implements Marshaller<Request<RegisterApplicationRevisionRequest>, RegisterApplicationRevisionRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public RegisterApplicationRevisionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<RegisterApplicationRevisionRequest> marshall(RegisterApplicationRevisionRequest registerApplicationRevisionRequest) {
        if (registerApplicationRevisionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RegisterApplicationRevisionRequest> request = new DefaultRequest<RegisterApplicationRevisionRequest>(registerApplicationRevisionRequest, "AmazonCodeDeploy");
        request.addHeader("X-Amz-Target", "CodeDeploy_20141006.RegisterApplicationRevision");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (registerApplicationRevisionRequest.getApplicationName() != null) {
                jsonGenerator.writeFieldName("applicationName").writeValue(registerApplicationRevisionRequest.getApplicationName());
            }
            if (registerApplicationRevisionRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(registerApplicationRevisionRequest.getDescription());
            }
            if (registerApplicationRevisionRequest.getRevision() != null) {
                jsonGenerator.writeFieldName("revision");
                RevisionLocationJsonMarshaller.getInstance().marshall(registerApplicationRevisionRequest.getRevision(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

