/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.rds.AmazonRDSAsync;
import com.amazonaws.services.rds.AmazonRDSClient;
import com.amazonaws.services.rds.model.AddSourceIdentifierToSubscriptionRequest;
import com.amazonaws.services.rds.model.AddTagsToResourceRequest;
import com.amazonaws.services.rds.model.AddTagsToResourceResult;
import com.amazonaws.services.rds.model.ApplyPendingMaintenanceActionRequest;
import com.amazonaws.services.rds.model.AuthorizeDBSecurityGroupIngressRequest;
import com.amazonaws.services.rds.model.CopyDBClusterParameterGroupRequest;
import com.amazonaws.services.rds.model.CopyDBClusterSnapshotRequest;
import com.amazonaws.services.rds.model.CopyDBParameterGroupRequest;
import com.amazonaws.services.rds.model.CopyDBSnapshotRequest;
import com.amazonaws.services.rds.model.CopyOptionGroupRequest;
import com.amazonaws.services.rds.model.CreateDBClusterParameterGroupRequest;
import com.amazonaws.services.rds.model.CreateDBClusterRequest;
import com.amazonaws.services.rds.model.CreateDBClusterSnapshotRequest;
import com.amazonaws.services.rds.model.CreateDBInstanceReadReplicaRequest;
import com.amazonaws.services.rds.model.CreateDBInstanceRequest;
import com.amazonaws.services.rds.model.CreateDBParameterGroupRequest;
import com.amazonaws.services.rds.model.CreateDBSecurityGroupRequest;
import com.amazonaws.services.rds.model.CreateDBSnapshotRequest;
import com.amazonaws.services.rds.model.CreateDBSubnetGroupRequest;
import com.amazonaws.services.rds.model.CreateEventSubscriptionRequest;
import com.amazonaws.services.rds.model.CreateOptionGroupRequest;
import com.amazonaws.services.rds.model.DBCluster;
import com.amazonaws.services.rds.model.DBClusterParameterGroup;
import com.amazonaws.services.rds.model.DBClusterSnapshot;
import com.amazonaws.services.rds.model.DBClusterSnapshotAttributesResult;
import com.amazonaws.services.rds.model.DBInstance;
import com.amazonaws.services.rds.model.DBParameterGroup;
import com.amazonaws.services.rds.model.DBSecurityGroup;
import com.amazonaws.services.rds.model.DBSnapshot;
import com.amazonaws.services.rds.model.DBSnapshotAttributesResult;
import com.amazonaws.services.rds.model.DBSubnetGroup;
import com.amazonaws.services.rds.model.DeleteDBClusterParameterGroupRequest;
import com.amazonaws.services.rds.model.DeleteDBClusterParameterGroupResult;
import com.amazonaws.services.rds.model.DeleteDBClusterRequest;
import com.amazonaws.services.rds.model.DeleteDBClusterSnapshotRequest;
import com.amazonaws.services.rds.model.DeleteDBInstanceRequest;
import com.amazonaws.services.rds.model.DeleteDBParameterGroupRequest;
import com.amazonaws.services.rds.model.DeleteDBParameterGroupResult;
import com.amazonaws.services.rds.model.DeleteDBSecurityGroupRequest;
import com.amazonaws.services.rds.model.DeleteDBSecurityGroupResult;
import com.amazonaws.services.rds.model.DeleteDBSnapshotRequest;
import com.amazonaws.services.rds.model.DeleteDBSubnetGroupRequest;
import com.amazonaws.services.rds.model.DeleteDBSubnetGroupResult;
import com.amazonaws.services.rds.model.DeleteEventSubscriptionRequest;
import com.amazonaws.services.rds.model.DeleteOptionGroupRequest;
import com.amazonaws.services.rds.model.DeleteOptionGroupResult;
import com.amazonaws.services.rds.model.DescribeAccountAttributesRequest;
import com.amazonaws.services.rds.model.DescribeAccountAttributesResult;
import com.amazonaws.services.rds.model.DescribeCertificatesRequest;
import com.amazonaws.services.rds.model.DescribeCertificatesResult;
import com.amazonaws.services.rds.model.DescribeDBClusterParameterGroupsRequest;
import com.amazonaws.services.rds.model.DescribeDBClusterParameterGroupsResult;
import com.amazonaws.services.rds.model.DescribeDBClusterParametersRequest;
import com.amazonaws.services.rds.model.DescribeDBClusterParametersResult;
import com.amazonaws.services.rds.model.DescribeDBClusterSnapshotAttributesRequest;
import com.amazonaws.services.rds.model.DescribeDBClusterSnapshotsRequest;
import com.amazonaws.services.rds.model.DescribeDBClusterSnapshotsResult;
import com.amazonaws.services.rds.model.DescribeDBClustersRequest;
import com.amazonaws.services.rds.model.DescribeDBClustersResult;
import com.amazonaws.services.rds.model.DescribeDBEngineVersionsRequest;
import com.amazonaws.services.rds.model.DescribeDBEngineVersionsResult;
import com.amazonaws.services.rds.model.DescribeDBInstancesRequest;
import com.amazonaws.services.rds.model.DescribeDBInstancesResult;
import com.amazonaws.services.rds.model.DescribeDBLogFilesRequest;
import com.amazonaws.services.rds.model.DescribeDBLogFilesResult;
import com.amazonaws.services.rds.model.DescribeDBParameterGroupsRequest;
import com.amazonaws.services.rds.model.DescribeDBParameterGroupsResult;
import com.amazonaws.services.rds.model.DescribeDBParametersRequest;
import com.amazonaws.services.rds.model.DescribeDBParametersResult;
import com.amazonaws.services.rds.model.DescribeDBSecurityGroupsRequest;
import com.amazonaws.services.rds.model.DescribeDBSecurityGroupsResult;
import com.amazonaws.services.rds.model.DescribeDBSnapshotAttributesRequest;
import com.amazonaws.services.rds.model.DescribeDBSnapshotsRequest;
import com.amazonaws.services.rds.model.DescribeDBSnapshotsResult;
import com.amazonaws.services.rds.model.DescribeDBSubnetGroupsRequest;
import com.amazonaws.services.rds.model.DescribeDBSubnetGroupsResult;
import com.amazonaws.services.rds.model.DescribeEngineDefaultClusterParametersRequest;
import com.amazonaws.services.rds.model.DescribeEngineDefaultParametersRequest;
import com.amazonaws.services.rds.model.DescribeEventCategoriesRequest;
import com.amazonaws.services.rds.model.DescribeEventCategoriesResult;
import com.amazonaws.services.rds.model.DescribeEventSubscriptionsRequest;
import com.amazonaws.services.rds.model.DescribeEventSubscriptionsResult;
import com.amazonaws.services.rds.model.DescribeEventsRequest;
import com.amazonaws.services.rds.model.DescribeEventsResult;
import com.amazonaws.services.rds.model.DescribeOptionGroupOptionsRequest;
import com.amazonaws.services.rds.model.DescribeOptionGroupOptionsResult;
import com.amazonaws.services.rds.model.DescribeOptionGroupsRequest;
import com.amazonaws.services.rds.model.DescribeOptionGroupsResult;
import com.amazonaws.services.rds.model.DescribeOrderableDBInstanceOptionsRequest;
import com.amazonaws.services.rds.model.DescribeOrderableDBInstanceOptionsResult;
import com.amazonaws.services.rds.model.DescribePendingMaintenanceActionsRequest;
import com.amazonaws.services.rds.model.DescribePendingMaintenanceActionsResult;
import com.amazonaws.services.rds.model.DescribeReservedDBInstancesOfferingsRequest;
import com.amazonaws.services.rds.model.DescribeReservedDBInstancesOfferingsResult;
import com.amazonaws.services.rds.model.DescribeReservedDBInstancesRequest;
import com.amazonaws.services.rds.model.DescribeReservedDBInstancesResult;
import com.amazonaws.services.rds.model.DescribeSourceRegionsRequest;
import com.amazonaws.services.rds.model.DescribeSourceRegionsResult;
import com.amazonaws.services.rds.model.DownloadDBLogFilePortionRequest;
import com.amazonaws.services.rds.model.DownloadDBLogFilePortionResult;
import com.amazonaws.services.rds.model.EngineDefaults;
import com.amazonaws.services.rds.model.EventSubscription;
import com.amazonaws.services.rds.model.FailoverDBClusterRequest;
import com.amazonaws.services.rds.model.ListTagsForResourceRequest;
import com.amazonaws.services.rds.model.ListTagsForResourceResult;
import com.amazonaws.services.rds.model.ModifyDBClusterParameterGroupRequest;
import com.amazonaws.services.rds.model.ModifyDBClusterParameterGroupResult;
import com.amazonaws.services.rds.model.ModifyDBClusterRequest;
import com.amazonaws.services.rds.model.ModifyDBClusterSnapshotAttributeRequest;
import com.amazonaws.services.rds.model.ModifyDBInstanceRequest;
import com.amazonaws.services.rds.model.ModifyDBParameterGroupRequest;
import com.amazonaws.services.rds.model.ModifyDBParameterGroupResult;
import com.amazonaws.services.rds.model.ModifyDBSnapshotAttributeRequest;
import com.amazonaws.services.rds.model.ModifyDBSubnetGroupRequest;
import com.amazonaws.services.rds.model.ModifyEventSubscriptionRequest;
import com.amazonaws.services.rds.model.ModifyOptionGroupRequest;
import com.amazonaws.services.rds.model.OptionGroup;
import com.amazonaws.services.rds.model.PromoteReadReplicaDBClusterRequest;
import com.amazonaws.services.rds.model.PromoteReadReplicaRequest;
import com.amazonaws.services.rds.model.PurchaseReservedDBInstancesOfferingRequest;
import com.amazonaws.services.rds.model.RebootDBInstanceRequest;
import com.amazonaws.services.rds.model.RemoveSourceIdentifierFromSubscriptionRequest;
import com.amazonaws.services.rds.model.RemoveTagsFromResourceRequest;
import com.amazonaws.services.rds.model.RemoveTagsFromResourceResult;
import com.amazonaws.services.rds.model.ReservedDBInstance;
import com.amazonaws.services.rds.model.ResetDBClusterParameterGroupRequest;
import com.amazonaws.services.rds.model.ResetDBClusterParameterGroupResult;
import com.amazonaws.services.rds.model.ResetDBParameterGroupRequest;
import com.amazonaws.services.rds.model.ResetDBParameterGroupResult;
import com.amazonaws.services.rds.model.ResourcePendingMaintenanceActions;
import com.amazonaws.services.rds.model.RestoreDBClusterFromS3Request;
import com.amazonaws.services.rds.model.RestoreDBClusterFromSnapshotRequest;
import com.amazonaws.services.rds.model.RestoreDBClusterToPointInTimeRequest;
import com.amazonaws.services.rds.model.RestoreDBInstanceFromDBSnapshotRequest;
import com.amazonaws.services.rds.model.RestoreDBInstanceToPointInTimeRequest;
import com.amazonaws.services.rds.model.RevokeDBSecurityGroupIngressRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonRDSAsyncClient
extends AmazonRDSClient
implements AmazonRDSAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonRDSAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonRDSAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonRDSAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonRDSAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AmazonRDSAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonRDSAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonRDSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonRDSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AmazonRDSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AmazonRDSAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<EventSubscription> addSourceIdentifierToSubscriptionAsync(AddSourceIdentifierToSubscriptionRequest request) {
        return this.addSourceIdentifierToSubscriptionAsync(request, null);
    }

    @Override
    public Future<EventSubscription> addSourceIdentifierToSubscriptionAsync(final AddSourceIdentifierToSubscriptionRequest request, final AsyncHandler<AddSourceIdentifierToSubscriptionRequest, EventSubscription> asyncHandler) {
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                EventSubscription result;
                try {
                    result = AmazonRDSAsyncClient.this.addSourceIdentifierToSubscription(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AddTagsToResourceResult> addTagsToResourceAsync(AddTagsToResourceRequest request) {
        return this.addTagsToResourceAsync(request, null);
    }

    @Override
    public Future<AddTagsToResourceResult> addTagsToResourceAsync(final AddTagsToResourceRequest request, final AsyncHandler<AddTagsToResourceRequest, AddTagsToResourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<AddTagsToResourceResult>(){

            @Override
            public AddTagsToResourceResult call() throws Exception {
                AddTagsToResourceResult result;
                try {
                    result = AmazonRDSAsyncClient.this.addTagsToResource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ResourcePendingMaintenanceActions> applyPendingMaintenanceActionAsync(ApplyPendingMaintenanceActionRequest request) {
        return this.applyPendingMaintenanceActionAsync(request, null);
    }

    @Override
    public Future<ResourcePendingMaintenanceActions> applyPendingMaintenanceActionAsync(final ApplyPendingMaintenanceActionRequest request, final AsyncHandler<ApplyPendingMaintenanceActionRequest, ResourcePendingMaintenanceActions> asyncHandler) {
        return this.executorService.submit(new Callable<ResourcePendingMaintenanceActions>(){

            @Override
            public ResourcePendingMaintenanceActions call() throws Exception {
                ResourcePendingMaintenanceActions result;
                try {
                    result = AmazonRDSAsyncClient.this.applyPendingMaintenanceAction(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBSecurityGroup> authorizeDBSecurityGroupIngressAsync(AuthorizeDBSecurityGroupIngressRequest request) {
        return this.authorizeDBSecurityGroupIngressAsync(request, null);
    }

    @Override
    public Future<DBSecurityGroup> authorizeDBSecurityGroupIngressAsync(final AuthorizeDBSecurityGroupIngressRequest request, final AsyncHandler<AuthorizeDBSecurityGroupIngressRequest, DBSecurityGroup> asyncHandler) {
        return this.executorService.submit(new Callable<DBSecurityGroup>(){

            @Override
            public DBSecurityGroup call() throws Exception {
                DBSecurityGroup result;
                try {
                    result = AmazonRDSAsyncClient.this.authorizeDBSecurityGroupIngress(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBClusterParameterGroup> copyDBClusterParameterGroupAsync(CopyDBClusterParameterGroupRequest request) {
        return this.copyDBClusterParameterGroupAsync(request, null);
    }

    @Override
    public Future<DBClusterParameterGroup> copyDBClusterParameterGroupAsync(final CopyDBClusterParameterGroupRequest request, final AsyncHandler<CopyDBClusterParameterGroupRequest, DBClusterParameterGroup> asyncHandler) {
        return this.executorService.submit(new Callable<DBClusterParameterGroup>(){

            @Override
            public DBClusterParameterGroup call() throws Exception {
                DBClusterParameterGroup result;
                try {
                    result = AmazonRDSAsyncClient.this.copyDBClusterParameterGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBClusterSnapshot> copyDBClusterSnapshotAsync(CopyDBClusterSnapshotRequest request) {
        return this.copyDBClusterSnapshotAsync(request, null);
    }

    @Override
    public Future<DBClusterSnapshot> copyDBClusterSnapshotAsync(final CopyDBClusterSnapshotRequest request, final AsyncHandler<CopyDBClusterSnapshotRequest, DBClusterSnapshot> asyncHandler) {
        return this.executorService.submit(new Callable<DBClusterSnapshot>(){

            @Override
            public DBClusterSnapshot call() throws Exception {
                DBClusterSnapshot result;
                try {
                    result = AmazonRDSAsyncClient.this.copyDBClusterSnapshot(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBParameterGroup> copyDBParameterGroupAsync(CopyDBParameterGroupRequest request) {
        return this.copyDBParameterGroupAsync(request, null);
    }

    @Override
    public Future<DBParameterGroup> copyDBParameterGroupAsync(final CopyDBParameterGroupRequest request, final AsyncHandler<CopyDBParameterGroupRequest, DBParameterGroup> asyncHandler) {
        return this.executorService.submit(new Callable<DBParameterGroup>(){

            @Override
            public DBParameterGroup call() throws Exception {
                DBParameterGroup result;
                try {
                    result = AmazonRDSAsyncClient.this.copyDBParameterGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBSnapshot> copyDBSnapshotAsync(CopyDBSnapshotRequest request) {
        return this.copyDBSnapshotAsync(request, null);
    }

    @Override
    public Future<DBSnapshot> copyDBSnapshotAsync(final CopyDBSnapshotRequest request, final AsyncHandler<CopyDBSnapshotRequest, DBSnapshot> asyncHandler) {
        return this.executorService.submit(new Callable<DBSnapshot>(){

            @Override
            public DBSnapshot call() throws Exception {
                DBSnapshot result;
                try {
                    result = AmazonRDSAsyncClient.this.copyDBSnapshot(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<OptionGroup> copyOptionGroupAsync(CopyOptionGroupRequest request) {
        return this.copyOptionGroupAsync(request, null);
    }

    @Override
    public Future<OptionGroup> copyOptionGroupAsync(final CopyOptionGroupRequest request, final AsyncHandler<CopyOptionGroupRequest, OptionGroup> asyncHandler) {
        return this.executorService.submit(new Callable<OptionGroup>(){

            @Override
            public OptionGroup call() throws Exception {
                OptionGroup result;
                try {
                    result = AmazonRDSAsyncClient.this.copyOptionGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBCluster> createDBClusterAsync(CreateDBClusterRequest request) {
        return this.createDBClusterAsync(request, null);
    }

    @Override
    public Future<DBCluster> createDBClusterAsync(final CreateDBClusterRequest request, final AsyncHandler<CreateDBClusterRequest, DBCluster> asyncHandler) {
        return this.executorService.submit(new Callable<DBCluster>(){

            @Override
            public DBCluster call() throws Exception {
                DBCluster result;
                try {
                    result = AmazonRDSAsyncClient.this.createDBCluster(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBClusterParameterGroup> createDBClusterParameterGroupAsync(CreateDBClusterParameterGroupRequest request) {
        return this.createDBClusterParameterGroupAsync(request, null);
    }

    @Override
    public Future<DBClusterParameterGroup> createDBClusterParameterGroupAsync(final CreateDBClusterParameterGroupRequest request, final AsyncHandler<CreateDBClusterParameterGroupRequest, DBClusterParameterGroup> asyncHandler) {
        return this.executorService.submit(new Callable<DBClusterParameterGroup>(){

            @Override
            public DBClusterParameterGroup call() throws Exception {
                DBClusterParameterGroup result;
                try {
                    result = AmazonRDSAsyncClient.this.createDBClusterParameterGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBClusterSnapshot> createDBClusterSnapshotAsync(CreateDBClusterSnapshotRequest request) {
        return this.createDBClusterSnapshotAsync(request, null);
    }

    @Override
    public Future<DBClusterSnapshot> createDBClusterSnapshotAsync(final CreateDBClusterSnapshotRequest request, final AsyncHandler<CreateDBClusterSnapshotRequest, DBClusterSnapshot> asyncHandler) {
        return this.executorService.submit(new Callable<DBClusterSnapshot>(){

            @Override
            public DBClusterSnapshot call() throws Exception {
                DBClusterSnapshot result;
                try {
                    result = AmazonRDSAsyncClient.this.createDBClusterSnapshot(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBInstance> createDBInstanceAsync(CreateDBInstanceRequest request) {
        return this.createDBInstanceAsync(request, null);
    }

    @Override
    public Future<DBInstance> createDBInstanceAsync(final CreateDBInstanceRequest request, final AsyncHandler<CreateDBInstanceRequest, DBInstance> asyncHandler) {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                DBInstance result;
                try {
                    result = AmazonRDSAsyncClient.this.createDBInstance(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBInstance> createDBInstanceReadReplicaAsync(CreateDBInstanceReadReplicaRequest request) {
        return this.createDBInstanceReadReplicaAsync(request, null);
    }

    @Override
    public Future<DBInstance> createDBInstanceReadReplicaAsync(final CreateDBInstanceReadReplicaRequest request, final AsyncHandler<CreateDBInstanceReadReplicaRequest, DBInstance> asyncHandler) {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                DBInstance result;
                try {
                    result = AmazonRDSAsyncClient.this.createDBInstanceReadReplica(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBParameterGroup> createDBParameterGroupAsync(CreateDBParameterGroupRequest request) {
        return this.createDBParameterGroupAsync(request, null);
    }

    @Override
    public Future<DBParameterGroup> createDBParameterGroupAsync(final CreateDBParameterGroupRequest request, final AsyncHandler<CreateDBParameterGroupRequest, DBParameterGroup> asyncHandler) {
        return this.executorService.submit(new Callable<DBParameterGroup>(){

            @Override
            public DBParameterGroup call() throws Exception {
                DBParameterGroup result;
                try {
                    result = AmazonRDSAsyncClient.this.createDBParameterGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBSecurityGroup> createDBSecurityGroupAsync(CreateDBSecurityGroupRequest request) {
        return this.createDBSecurityGroupAsync(request, null);
    }

    @Override
    public Future<DBSecurityGroup> createDBSecurityGroupAsync(final CreateDBSecurityGroupRequest request, final AsyncHandler<CreateDBSecurityGroupRequest, DBSecurityGroup> asyncHandler) {
        return this.executorService.submit(new Callable<DBSecurityGroup>(){

            @Override
            public DBSecurityGroup call() throws Exception {
                DBSecurityGroup result;
                try {
                    result = AmazonRDSAsyncClient.this.createDBSecurityGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBSnapshot> createDBSnapshotAsync(CreateDBSnapshotRequest request) {
        return this.createDBSnapshotAsync(request, null);
    }

    @Override
    public Future<DBSnapshot> createDBSnapshotAsync(final CreateDBSnapshotRequest request, final AsyncHandler<CreateDBSnapshotRequest, DBSnapshot> asyncHandler) {
        return this.executorService.submit(new Callable<DBSnapshot>(){

            @Override
            public DBSnapshot call() throws Exception {
                DBSnapshot result;
                try {
                    result = AmazonRDSAsyncClient.this.createDBSnapshot(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBSubnetGroup> createDBSubnetGroupAsync(CreateDBSubnetGroupRequest request) {
        return this.createDBSubnetGroupAsync(request, null);
    }

    @Override
    public Future<DBSubnetGroup> createDBSubnetGroupAsync(final CreateDBSubnetGroupRequest request, final AsyncHandler<CreateDBSubnetGroupRequest, DBSubnetGroup> asyncHandler) {
        return this.executorService.submit(new Callable<DBSubnetGroup>(){

            @Override
            public DBSubnetGroup call() throws Exception {
                DBSubnetGroup result;
                try {
                    result = AmazonRDSAsyncClient.this.createDBSubnetGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EventSubscription> createEventSubscriptionAsync(CreateEventSubscriptionRequest request) {
        return this.createEventSubscriptionAsync(request, null);
    }

    @Override
    public Future<EventSubscription> createEventSubscriptionAsync(final CreateEventSubscriptionRequest request, final AsyncHandler<CreateEventSubscriptionRequest, EventSubscription> asyncHandler) {
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                EventSubscription result;
                try {
                    result = AmazonRDSAsyncClient.this.createEventSubscription(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<OptionGroup> createOptionGroupAsync(CreateOptionGroupRequest request) {
        return this.createOptionGroupAsync(request, null);
    }

    @Override
    public Future<OptionGroup> createOptionGroupAsync(final CreateOptionGroupRequest request, final AsyncHandler<CreateOptionGroupRequest, OptionGroup> asyncHandler) {
        return this.executorService.submit(new Callable<OptionGroup>(){

            @Override
            public OptionGroup call() throws Exception {
                OptionGroup result;
                try {
                    result = AmazonRDSAsyncClient.this.createOptionGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBCluster> deleteDBClusterAsync(DeleteDBClusterRequest request) {
        return this.deleteDBClusterAsync(request, null);
    }

    @Override
    public Future<DBCluster> deleteDBClusterAsync(final DeleteDBClusterRequest request, final AsyncHandler<DeleteDBClusterRequest, DBCluster> asyncHandler) {
        return this.executorService.submit(new Callable<DBCluster>(){

            @Override
            public DBCluster call() throws Exception {
                DBCluster result;
                try {
                    result = AmazonRDSAsyncClient.this.deleteDBCluster(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDBClusterParameterGroupResult> deleteDBClusterParameterGroupAsync(DeleteDBClusterParameterGroupRequest request) {
        return this.deleteDBClusterParameterGroupAsync(request, null);
    }

    @Override
    public Future<DeleteDBClusterParameterGroupResult> deleteDBClusterParameterGroupAsync(final DeleteDBClusterParameterGroupRequest request, final AsyncHandler<DeleteDBClusterParameterGroupRequest, DeleteDBClusterParameterGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteDBClusterParameterGroupResult>(){

            @Override
            public DeleteDBClusterParameterGroupResult call() throws Exception {
                DeleteDBClusterParameterGroupResult result;
                try {
                    result = AmazonRDSAsyncClient.this.deleteDBClusterParameterGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBClusterSnapshot> deleteDBClusterSnapshotAsync(DeleteDBClusterSnapshotRequest request) {
        return this.deleteDBClusterSnapshotAsync(request, null);
    }

    @Override
    public Future<DBClusterSnapshot> deleteDBClusterSnapshotAsync(final DeleteDBClusterSnapshotRequest request, final AsyncHandler<DeleteDBClusterSnapshotRequest, DBClusterSnapshot> asyncHandler) {
        return this.executorService.submit(new Callable<DBClusterSnapshot>(){

            @Override
            public DBClusterSnapshot call() throws Exception {
                DBClusterSnapshot result;
                try {
                    result = AmazonRDSAsyncClient.this.deleteDBClusterSnapshot(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBInstance> deleteDBInstanceAsync(DeleteDBInstanceRequest request) {
        return this.deleteDBInstanceAsync(request, null);
    }

    @Override
    public Future<DBInstance> deleteDBInstanceAsync(final DeleteDBInstanceRequest request, final AsyncHandler<DeleteDBInstanceRequest, DBInstance> asyncHandler) {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                DBInstance result;
                try {
                    result = AmazonRDSAsyncClient.this.deleteDBInstance(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDBParameterGroupResult> deleteDBParameterGroupAsync(DeleteDBParameterGroupRequest request) {
        return this.deleteDBParameterGroupAsync(request, null);
    }

    @Override
    public Future<DeleteDBParameterGroupResult> deleteDBParameterGroupAsync(final DeleteDBParameterGroupRequest request, final AsyncHandler<DeleteDBParameterGroupRequest, DeleteDBParameterGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteDBParameterGroupResult>(){

            @Override
            public DeleteDBParameterGroupResult call() throws Exception {
                DeleteDBParameterGroupResult result;
                try {
                    result = AmazonRDSAsyncClient.this.deleteDBParameterGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDBSecurityGroupResult> deleteDBSecurityGroupAsync(DeleteDBSecurityGroupRequest request) {
        return this.deleteDBSecurityGroupAsync(request, null);
    }

    @Override
    public Future<DeleteDBSecurityGroupResult> deleteDBSecurityGroupAsync(final DeleteDBSecurityGroupRequest request, final AsyncHandler<DeleteDBSecurityGroupRequest, DeleteDBSecurityGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteDBSecurityGroupResult>(){

            @Override
            public DeleteDBSecurityGroupResult call() throws Exception {
                DeleteDBSecurityGroupResult result;
                try {
                    result = AmazonRDSAsyncClient.this.deleteDBSecurityGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBSnapshot> deleteDBSnapshotAsync(DeleteDBSnapshotRequest request) {
        return this.deleteDBSnapshotAsync(request, null);
    }

    @Override
    public Future<DBSnapshot> deleteDBSnapshotAsync(final DeleteDBSnapshotRequest request, final AsyncHandler<DeleteDBSnapshotRequest, DBSnapshot> asyncHandler) {
        return this.executorService.submit(new Callable<DBSnapshot>(){

            @Override
            public DBSnapshot call() throws Exception {
                DBSnapshot result;
                try {
                    result = AmazonRDSAsyncClient.this.deleteDBSnapshot(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDBSubnetGroupResult> deleteDBSubnetGroupAsync(DeleteDBSubnetGroupRequest request) {
        return this.deleteDBSubnetGroupAsync(request, null);
    }

    @Override
    public Future<DeleteDBSubnetGroupResult> deleteDBSubnetGroupAsync(final DeleteDBSubnetGroupRequest request, final AsyncHandler<DeleteDBSubnetGroupRequest, DeleteDBSubnetGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteDBSubnetGroupResult>(){

            @Override
            public DeleteDBSubnetGroupResult call() throws Exception {
                DeleteDBSubnetGroupResult result;
                try {
                    result = AmazonRDSAsyncClient.this.deleteDBSubnetGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EventSubscription> deleteEventSubscriptionAsync(DeleteEventSubscriptionRequest request) {
        return this.deleteEventSubscriptionAsync(request, null);
    }

    @Override
    public Future<EventSubscription> deleteEventSubscriptionAsync(final DeleteEventSubscriptionRequest request, final AsyncHandler<DeleteEventSubscriptionRequest, EventSubscription> asyncHandler) {
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                EventSubscription result;
                try {
                    result = AmazonRDSAsyncClient.this.deleteEventSubscription(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteOptionGroupResult> deleteOptionGroupAsync(DeleteOptionGroupRequest request) {
        return this.deleteOptionGroupAsync(request, null);
    }

    @Override
    public Future<DeleteOptionGroupResult> deleteOptionGroupAsync(final DeleteOptionGroupRequest request, final AsyncHandler<DeleteOptionGroupRequest, DeleteOptionGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteOptionGroupResult>(){

            @Override
            public DeleteOptionGroupResult call() throws Exception {
                DeleteOptionGroupResult result;
                try {
                    result = AmazonRDSAsyncClient.this.deleteOptionGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAccountAttributesResult> describeAccountAttributesAsync(DescribeAccountAttributesRequest request) {
        return this.describeAccountAttributesAsync(request, null);
    }

    @Override
    public Future<DescribeAccountAttributesResult> describeAccountAttributesAsync(final DescribeAccountAttributesRequest request, final AsyncHandler<DescribeAccountAttributesRequest, DescribeAccountAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeAccountAttributesResult>(){

            @Override
            public DescribeAccountAttributesResult call() throws Exception {
                DescribeAccountAttributesResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeAccountAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAccountAttributesResult> describeAccountAttributesAsync() {
        return this.describeAccountAttributesAsync(new DescribeAccountAttributesRequest());
    }

    @Override
    public Future<DescribeAccountAttributesResult> describeAccountAttributesAsync(AsyncHandler<DescribeAccountAttributesRequest, DescribeAccountAttributesResult> asyncHandler) {
        return this.describeAccountAttributesAsync(new DescribeAccountAttributesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeCertificatesResult> describeCertificatesAsync(DescribeCertificatesRequest request) {
        return this.describeCertificatesAsync(request, null);
    }

    @Override
    public Future<DescribeCertificatesResult> describeCertificatesAsync(final DescribeCertificatesRequest request, final AsyncHandler<DescribeCertificatesRequest, DescribeCertificatesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeCertificatesResult>(){

            @Override
            public DescribeCertificatesResult call() throws Exception {
                DescribeCertificatesResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeCertificates(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCertificatesResult> describeCertificatesAsync() {
        return this.describeCertificatesAsync(new DescribeCertificatesRequest());
    }

    @Override
    public Future<DescribeCertificatesResult> describeCertificatesAsync(AsyncHandler<DescribeCertificatesRequest, DescribeCertificatesResult> asyncHandler) {
        return this.describeCertificatesAsync(new DescribeCertificatesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeDBClusterParameterGroupsResult> describeDBClusterParameterGroupsAsync(DescribeDBClusterParameterGroupsRequest request) {
        return this.describeDBClusterParameterGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeDBClusterParameterGroupsResult> describeDBClusterParameterGroupsAsync(final DescribeDBClusterParameterGroupsRequest request, final AsyncHandler<DescribeDBClusterParameterGroupsRequest, DescribeDBClusterParameterGroupsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeDBClusterParameterGroupsResult>(){

            @Override
            public DescribeDBClusterParameterGroupsResult call() throws Exception {
                DescribeDBClusterParameterGroupsResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeDBClusterParameterGroups(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBClusterParameterGroupsResult> describeDBClusterParameterGroupsAsync() {
        return this.describeDBClusterParameterGroupsAsync(new DescribeDBClusterParameterGroupsRequest());
    }

    @Override
    public Future<DescribeDBClusterParameterGroupsResult> describeDBClusterParameterGroupsAsync(AsyncHandler<DescribeDBClusterParameterGroupsRequest, DescribeDBClusterParameterGroupsResult> asyncHandler) {
        return this.describeDBClusterParameterGroupsAsync(new DescribeDBClusterParameterGroupsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeDBClusterParametersResult> describeDBClusterParametersAsync(DescribeDBClusterParametersRequest request) {
        return this.describeDBClusterParametersAsync(request, null);
    }

    @Override
    public Future<DescribeDBClusterParametersResult> describeDBClusterParametersAsync(final DescribeDBClusterParametersRequest request, final AsyncHandler<DescribeDBClusterParametersRequest, DescribeDBClusterParametersResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeDBClusterParametersResult>(){

            @Override
            public DescribeDBClusterParametersResult call() throws Exception {
                DescribeDBClusterParametersResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeDBClusterParameters(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBClusterSnapshotAttributesResult> describeDBClusterSnapshotAttributesAsync(DescribeDBClusterSnapshotAttributesRequest request) {
        return this.describeDBClusterSnapshotAttributesAsync(request, null);
    }

    @Override
    public Future<DBClusterSnapshotAttributesResult> describeDBClusterSnapshotAttributesAsync(final DescribeDBClusterSnapshotAttributesRequest request, final AsyncHandler<DescribeDBClusterSnapshotAttributesRequest, DBClusterSnapshotAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DBClusterSnapshotAttributesResult>(){

            @Override
            public DBClusterSnapshotAttributesResult call() throws Exception {
                DBClusterSnapshotAttributesResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeDBClusterSnapshotAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBClusterSnapshotsResult> describeDBClusterSnapshotsAsync(DescribeDBClusterSnapshotsRequest request) {
        return this.describeDBClusterSnapshotsAsync(request, null);
    }

    @Override
    public Future<DescribeDBClusterSnapshotsResult> describeDBClusterSnapshotsAsync(final DescribeDBClusterSnapshotsRequest request, final AsyncHandler<DescribeDBClusterSnapshotsRequest, DescribeDBClusterSnapshotsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeDBClusterSnapshotsResult>(){

            @Override
            public DescribeDBClusterSnapshotsResult call() throws Exception {
                DescribeDBClusterSnapshotsResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeDBClusterSnapshots(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBClusterSnapshotsResult> describeDBClusterSnapshotsAsync() {
        return this.describeDBClusterSnapshotsAsync(new DescribeDBClusterSnapshotsRequest());
    }

    @Override
    public Future<DescribeDBClusterSnapshotsResult> describeDBClusterSnapshotsAsync(AsyncHandler<DescribeDBClusterSnapshotsRequest, DescribeDBClusterSnapshotsResult> asyncHandler) {
        return this.describeDBClusterSnapshotsAsync(new DescribeDBClusterSnapshotsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeDBClustersResult> describeDBClustersAsync(DescribeDBClustersRequest request) {
        return this.describeDBClustersAsync(request, null);
    }

    @Override
    public Future<DescribeDBClustersResult> describeDBClustersAsync(final DescribeDBClustersRequest request, final AsyncHandler<DescribeDBClustersRequest, DescribeDBClustersResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeDBClustersResult>(){

            @Override
            public DescribeDBClustersResult call() throws Exception {
                DescribeDBClustersResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeDBClusters(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBClustersResult> describeDBClustersAsync() {
        return this.describeDBClustersAsync(new DescribeDBClustersRequest());
    }

    @Override
    public Future<DescribeDBClustersResult> describeDBClustersAsync(AsyncHandler<DescribeDBClustersRequest, DescribeDBClustersResult> asyncHandler) {
        return this.describeDBClustersAsync(new DescribeDBClustersRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeDBEngineVersionsResult> describeDBEngineVersionsAsync(DescribeDBEngineVersionsRequest request) {
        return this.describeDBEngineVersionsAsync(request, null);
    }

    @Override
    public Future<DescribeDBEngineVersionsResult> describeDBEngineVersionsAsync(final DescribeDBEngineVersionsRequest request, final AsyncHandler<DescribeDBEngineVersionsRequest, DescribeDBEngineVersionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeDBEngineVersionsResult>(){

            @Override
            public DescribeDBEngineVersionsResult call() throws Exception {
                DescribeDBEngineVersionsResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeDBEngineVersions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBEngineVersionsResult> describeDBEngineVersionsAsync() {
        return this.describeDBEngineVersionsAsync(new DescribeDBEngineVersionsRequest());
    }

    @Override
    public Future<DescribeDBEngineVersionsResult> describeDBEngineVersionsAsync(AsyncHandler<DescribeDBEngineVersionsRequest, DescribeDBEngineVersionsResult> asyncHandler) {
        return this.describeDBEngineVersionsAsync(new DescribeDBEngineVersionsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeDBInstancesResult> describeDBInstancesAsync(DescribeDBInstancesRequest request) {
        return this.describeDBInstancesAsync(request, null);
    }

    @Override
    public Future<DescribeDBInstancesResult> describeDBInstancesAsync(final DescribeDBInstancesRequest request, final AsyncHandler<DescribeDBInstancesRequest, DescribeDBInstancesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeDBInstancesResult>(){

            @Override
            public DescribeDBInstancesResult call() throws Exception {
                DescribeDBInstancesResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeDBInstances(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBInstancesResult> describeDBInstancesAsync() {
        return this.describeDBInstancesAsync(new DescribeDBInstancesRequest());
    }

    @Override
    public Future<DescribeDBInstancesResult> describeDBInstancesAsync(AsyncHandler<DescribeDBInstancesRequest, DescribeDBInstancesResult> asyncHandler) {
        return this.describeDBInstancesAsync(new DescribeDBInstancesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeDBLogFilesResult> describeDBLogFilesAsync(DescribeDBLogFilesRequest request) {
        return this.describeDBLogFilesAsync(request, null);
    }

    @Override
    public Future<DescribeDBLogFilesResult> describeDBLogFilesAsync(final DescribeDBLogFilesRequest request, final AsyncHandler<DescribeDBLogFilesRequest, DescribeDBLogFilesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeDBLogFilesResult>(){

            @Override
            public DescribeDBLogFilesResult call() throws Exception {
                DescribeDBLogFilesResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeDBLogFiles(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBParameterGroupsResult> describeDBParameterGroupsAsync(DescribeDBParameterGroupsRequest request) {
        return this.describeDBParameterGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeDBParameterGroupsResult> describeDBParameterGroupsAsync(final DescribeDBParameterGroupsRequest request, final AsyncHandler<DescribeDBParameterGroupsRequest, DescribeDBParameterGroupsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeDBParameterGroupsResult>(){

            @Override
            public DescribeDBParameterGroupsResult call() throws Exception {
                DescribeDBParameterGroupsResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeDBParameterGroups(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBParameterGroupsResult> describeDBParameterGroupsAsync() {
        return this.describeDBParameterGroupsAsync(new DescribeDBParameterGroupsRequest());
    }

    @Override
    public Future<DescribeDBParameterGroupsResult> describeDBParameterGroupsAsync(AsyncHandler<DescribeDBParameterGroupsRequest, DescribeDBParameterGroupsResult> asyncHandler) {
        return this.describeDBParameterGroupsAsync(new DescribeDBParameterGroupsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeDBParametersResult> describeDBParametersAsync(DescribeDBParametersRequest request) {
        return this.describeDBParametersAsync(request, null);
    }

    @Override
    public Future<DescribeDBParametersResult> describeDBParametersAsync(final DescribeDBParametersRequest request, final AsyncHandler<DescribeDBParametersRequest, DescribeDBParametersResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeDBParametersResult>(){

            @Override
            public DescribeDBParametersResult call() throws Exception {
                DescribeDBParametersResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeDBParameters(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBSecurityGroupsResult> describeDBSecurityGroupsAsync(DescribeDBSecurityGroupsRequest request) {
        return this.describeDBSecurityGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeDBSecurityGroupsResult> describeDBSecurityGroupsAsync(final DescribeDBSecurityGroupsRequest request, final AsyncHandler<DescribeDBSecurityGroupsRequest, DescribeDBSecurityGroupsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeDBSecurityGroupsResult>(){

            @Override
            public DescribeDBSecurityGroupsResult call() throws Exception {
                DescribeDBSecurityGroupsResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeDBSecurityGroups(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBSecurityGroupsResult> describeDBSecurityGroupsAsync() {
        return this.describeDBSecurityGroupsAsync(new DescribeDBSecurityGroupsRequest());
    }

    @Override
    public Future<DescribeDBSecurityGroupsResult> describeDBSecurityGroupsAsync(AsyncHandler<DescribeDBSecurityGroupsRequest, DescribeDBSecurityGroupsResult> asyncHandler) {
        return this.describeDBSecurityGroupsAsync(new DescribeDBSecurityGroupsRequest(), asyncHandler);
    }

    @Override
    public Future<DBSnapshotAttributesResult> describeDBSnapshotAttributesAsync(DescribeDBSnapshotAttributesRequest request) {
        return this.describeDBSnapshotAttributesAsync(request, null);
    }

    @Override
    public Future<DBSnapshotAttributesResult> describeDBSnapshotAttributesAsync(final DescribeDBSnapshotAttributesRequest request, final AsyncHandler<DescribeDBSnapshotAttributesRequest, DBSnapshotAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DBSnapshotAttributesResult>(){

            @Override
            public DBSnapshotAttributesResult call() throws Exception {
                DBSnapshotAttributesResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeDBSnapshotAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBSnapshotAttributesResult> describeDBSnapshotAttributesAsync() {
        return this.describeDBSnapshotAttributesAsync(new DescribeDBSnapshotAttributesRequest());
    }

    @Override
    public Future<DBSnapshotAttributesResult> describeDBSnapshotAttributesAsync(AsyncHandler<DescribeDBSnapshotAttributesRequest, DBSnapshotAttributesResult> asyncHandler) {
        return this.describeDBSnapshotAttributesAsync(new DescribeDBSnapshotAttributesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeDBSnapshotsResult> describeDBSnapshotsAsync(DescribeDBSnapshotsRequest request) {
        return this.describeDBSnapshotsAsync(request, null);
    }

    @Override
    public Future<DescribeDBSnapshotsResult> describeDBSnapshotsAsync(final DescribeDBSnapshotsRequest request, final AsyncHandler<DescribeDBSnapshotsRequest, DescribeDBSnapshotsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeDBSnapshotsResult>(){

            @Override
            public DescribeDBSnapshotsResult call() throws Exception {
                DescribeDBSnapshotsResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeDBSnapshots(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBSnapshotsResult> describeDBSnapshotsAsync() {
        return this.describeDBSnapshotsAsync(new DescribeDBSnapshotsRequest());
    }

    @Override
    public Future<DescribeDBSnapshotsResult> describeDBSnapshotsAsync(AsyncHandler<DescribeDBSnapshotsRequest, DescribeDBSnapshotsResult> asyncHandler) {
        return this.describeDBSnapshotsAsync(new DescribeDBSnapshotsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeDBSubnetGroupsResult> describeDBSubnetGroupsAsync(DescribeDBSubnetGroupsRequest request) {
        return this.describeDBSubnetGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeDBSubnetGroupsResult> describeDBSubnetGroupsAsync(final DescribeDBSubnetGroupsRequest request, final AsyncHandler<DescribeDBSubnetGroupsRequest, DescribeDBSubnetGroupsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeDBSubnetGroupsResult>(){

            @Override
            public DescribeDBSubnetGroupsResult call() throws Exception {
                DescribeDBSubnetGroupsResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeDBSubnetGroups(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDBSubnetGroupsResult> describeDBSubnetGroupsAsync() {
        return this.describeDBSubnetGroupsAsync(new DescribeDBSubnetGroupsRequest());
    }

    @Override
    public Future<DescribeDBSubnetGroupsResult> describeDBSubnetGroupsAsync(AsyncHandler<DescribeDBSubnetGroupsRequest, DescribeDBSubnetGroupsResult> asyncHandler) {
        return this.describeDBSubnetGroupsAsync(new DescribeDBSubnetGroupsRequest(), asyncHandler);
    }

    @Override
    public Future<EngineDefaults> describeEngineDefaultClusterParametersAsync(DescribeEngineDefaultClusterParametersRequest request) {
        return this.describeEngineDefaultClusterParametersAsync(request, null);
    }

    @Override
    public Future<EngineDefaults> describeEngineDefaultClusterParametersAsync(final DescribeEngineDefaultClusterParametersRequest request, final AsyncHandler<DescribeEngineDefaultClusterParametersRequest, EngineDefaults> asyncHandler) {
        return this.executorService.submit(new Callable<EngineDefaults>(){

            @Override
            public EngineDefaults call() throws Exception {
                EngineDefaults result;
                try {
                    result = AmazonRDSAsyncClient.this.describeEngineDefaultClusterParameters(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EngineDefaults> describeEngineDefaultParametersAsync(DescribeEngineDefaultParametersRequest request) {
        return this.describeEngineDefaultParametersAsync(request, null);
    }

    @Override
    public Future<EngineDefaults> describeEngineDefaultParametersAsync(final DescribeEngineDefaultParametersRequest request, final AsyncHandler<DescribeEngineDefaultParametersRequest, EngineDefaults> asyncHandler) {
        return this.executorService.submit(new Callable<EngineDefaults>(){

            @Override
            public EngineDefaults call() throws Exception {
                EngineDefaults result;
                try {
                    result = AmazonRDSAsyncClient.this.describeEngineDefaultParameters(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventCategoriesResult> describeEventCategoriesAsync(DescribeEventCategoriesRequest request) {
        return this.describeEventCategoriesAsync(request, null);
    }

    @Override
    public Future<DescribeEventCategoriesResult> describeEventCategoriesAsync(final DescribeEventCategoriesRequest request, final AsyncHandler<DescribeEventCategoriesRequest, DescribeEventCategoriesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeEventCategoriesResult>(){

            @Override
            public DescribeEventCategoriesResult call() throws Exception {
                DescribeEventCategoriesResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeEventCategories(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventCategoriesResult> describeEventCategoriesAsync() {
        return this.describeEventCategoriesAsync(new DescribeEventCategoriesRequest());
    }

    @Override
    public Future<DescribeEventCategoriesResult> describeEventCategoriesAsync(AsyncHandler<DescribeEventCategoriesRequest, DescribeEventCategoriesResult> asyncHandler) {
        return this.describeEventCategoriesAsync(new DescribeEventCategoriesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeEventSubscriptionsResult> describeEventSubscriptionsAsync(DescribeEventSubscriptionsRequest request) {
        return this.describeEventSubscriptionsAsync(request, null);
    }

    @Override
    public Future<DescribeEventSubscriptionsResult> describeEventSubscriptionsAsync(final DescribeEventSubscriptionsRequest request, final AsyncHandler<DescribeEventSubscriptionsRequest, DescribeEventSubscriptionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeEventSubscriptionsResult>(){

            @Override
            public DescribeEventSubscriptionsResult call() throws Exception {
                DescribeEventSubscriptionsResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeEventSubscriptions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventSubscriptionsResult> describeEventSubscriptionsAsync() {
        return this.describeEventSubscriptionsAsync(new DescribeEventSubscriptionsRequest());
    }

    @Override
    public Future<DescribeEventSubscriptionsResult> describeEventSubscriptionsAsync(AsyncHandler<DescribeEventSubscriptionsRequest, DescribeEventSubscriptionsResult> asyncHandler) {
        return this.describeEventSubscriptionsAsync(new DescribeEventSubscriptionsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(DescribeEventsRequest request) {
        return this.describeEventsAsync(request, null);
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(final DescribeEventsRequest request, final AsyncHandler<DescribeEventsRequest, DescribeEventsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeEventsResult>(){

            @Override
            public DescribeEventsResult call() throws Exception {
                DescribeEventsResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeEvents(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync() {
        return this.describeEventsAsync(new DescribeEventsRequest());
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(AsyncHandler<DescribeEventsRequest, DescribeEventsResult> asyncHandler) {
        return this.describeEventsAsync(new DescribeEventsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeOptionGroupOptionsResult> describeOptionGroupOptionsAsync(DescribeOptionGroupOptionsRequest request) {
        return this.describeOptionGroupOptionsAsync(request, null);
    }

    @Override
    public Future<DescribeOptionGroupOptionsResult> describeOptionGroupOptionsAsync(final DescribeOptionGroupOptionsRequest request, final AsyncHandler<DescribeOptionGroupOptionsRequest, DescribeOptionGroupOptionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeOptionGroupOptionsResult>(){

            @Override
            public DescribeOptionGroupOptionsResult call() throws Exception {
                DescribeOptionGroupOptionsResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeOptionGroupOptions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeOptionGroupsResult> describeOptionGroupsAsync(DescribeOptionGroupsRequest request) {
        return this.describeOptionGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeOptionGroupsResult> describeOptionGroupsAsync(final DescribeOptionGroupsRequest request, final AsyncHandler<DescribeOptionGroupsRequest, DescribeOptionGroupsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeOptionGroupsResult>(){

            @Override
            public DescribeOptionGroupsResult call() throws Exception {
                DescribeOptionGroupsResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeOptionGroups(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeOptionGroupsResult> describeOptionGroupsAsync() {
        return this.describeOptionGroupsAsync(new DescribeOptionGroupsRequest());
    }

    @Override
    public Future<DescribeOptionGroupsResult> describeOptionGroupsAsync(AsyncHandler<DescribeOptionGroupsRequest, DescribeOptionGroupsResult> asyncHandler) {
        return this.describeOptionGroupsAsync(new DescribeOptionGroupsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeOrderableDBInstanceOptionsResult> describeOrderableDBInstanceOptionsAsync(DescribeOrderableDBInstanceOptionsRequest request) {
        return this.describeOrderableDBInstanceOptionsAsync(request, null);
    }

    @Override
    public Future<DescribeOrderableDBInstanceOptionsResult> describeOrderableDBInstanceOptionsAsync(final DescribeOrderableDBInstanceOptionsRequest request, final AsyncHandler<DescribeOrderableDBInstanceOptionsRequest, DescribeOrderableDBInstanceOptionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeOrderableDBInstanceOptionsResult>(){

            @Override
            public DescribeOrderableDBInstanceOptionsResult call() throws Exception {
                DescribeOrderableDBInstanceOptionsResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeOrderableDBInstanceOptions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribePendingMaintenanceActionsResult> describePendingMaintenanceActionsAsync(DescribePendingMaintenanceActionsRequest request) {
        return this.describePendingMaintenanceActionsAsync(request, null);
    }

    @Override
    public Future<DescribePendingMaintenanceActionsResult> describePendingMaintenanceActionsAsync(final DescribePendingMaintenanceActionsRequest request, final AsyncHandler<DescribePendingMaintenanceActionsRequest, DescribePendingMaintenanceActionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribePendingMaintenanceActionsResult>(){

            @Override
            public DescribePendingMaintenanceActionsResult call() throws Exception {
                DescribePendingMaintenanceActionsResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describePendingMaintenanceActions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribePendingMaintenanceActionsResult> describePendingMaintenanceActionsAsync() {
        return this.describePendingMaintenanceActionsAsync(new DescribePendingMaintenanceActionsRequest());
    }

    @Override
    public Future<DescribePendingMaintenanceActionsResult> describePendingMaintenanceActionsAsync(AsyncHandler<DescribePendingMaintenanceActionsRequest, DescribePendingMaintenanceActionsResult> asyncHandler) {
        return this.describePendingMaintenanceActionsAsync(new DescribePendingMaintenanceActionsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeReservedDBInstancesResult> describeReservedDBInstancesAsync(DescribeReservedDBInstancesRequest request) {
        return this.describeReservedDBInstancesAsync(request, null);
    }

    @Override
    public Future<DescribeReservedDBInstancesResult> describeReservedDBInstancesAsync(final DescribeReservedDBInstancesRequest request, final AsyncHandler<DescribeReservedDBInstancesRequest, DescribeReservedDBInstancesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeReservedDBInstancesResult>(){

            @Override
            public DescribeReservedDBInstancesResult call() throws Exception {
                DescribeReservedDBInstancesResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeReservedDBInstances(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReservedDBInstancesResult> describeReservedDBInstancesAsync() {
        return this.describeReservedDBInstancesAsync(new DescribeReservedDBInstancesRequest());
    }

    @Override
    public Future<DescribeReservedDBInstancesResult> describeReservedDBInstancesAsync(AsyncHandler<DescribeReservedDBInstancesRequest, DescribeReservedDBInstancesResult> asyncHandler) {
        return this.describeReservedDBInstancesAsync(new DescribeReservedDBInstancesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeReservedDBInstancesOfferingsResult> describeReservedDBInstancesOfferingsAsync(DescribeReservedDBInstancesOfferingsRequest request) {
        return this.describeReservedDBInstancesOfferingsAsync(request, null);
    }

    @Override
    public Future<DescribeReservedDBInstancesOfferingsResult> describeReservedDBInstancesOfferingsAsync(final DescribeReservedDBInstancesOfferingsRequest request, final AsyncHandler<DescribeReservedDBInstancesOfferingsRequest, DescribeReservedDBInstancesOfferingsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeReservedDBInstancesOfferingsResult>(){

            @Override
            public DescribeReservedDBInstancesOfferingsResult call() throws Exception {
                DescribeReservedDBInstancesOfferingsResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeReservedDBInstancesOfferings(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReservedDBInstancesOfferingsResult> describeReservedDBInstancesOfferingsAsync() {
        return this.describeReservedDBInstancesOfferingsAsync(new DescribeReservedDBInstancesOfferingsRequest());
    }

    @Override
    public Future<DescribeReservedDBInstancesOfferingsResult> describeReservedDBInstancesOfferingsAsync(AsyncHandler<DescribeReservedDBInstancesOfferingsRequest, DescribeReservedDBInstancesOfferingsResult> asyncHandler) {
        return this.describeReservedDBInstancesOfferingsAsync(new DescribeReservedDBInstancesOfferingsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeSourceRegionsResult> describeSourceRegionsAsync(DescribeSourceRegionsRequest request) {
        return this.describeSourceRegionsAsync(request, null);
    }

    @Override
    public Future<DescribeSourceRegionsResult> describeSourceRegionsAsync(final DescribeSourceRegionsRequest request, final AsyncHandler<DescribeSourceRegionsRequest, DescribeSourceRegionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeSourceRegionsResult>(){

            @Override
            public DescribeSourceRegionsResult call() throws Exception {
                DescribeSourceRegionsResult result;
                try {
                    result = AmazonRDSAsyncClient.this.describeSourceRegions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DownloadDBLogFilePortionResult> downloadDBLogFilePortionAsync(DownloadDBLogFilePortionRequest request) {
        return this.downloadDBLogFilePortionAsync(request, null);
    }

    @Override
    public Future<DownloadDBLogFilePortionResult> downloadDBLogFilePortionAsync(final DownloadDBLogFilePortionRequest request, final AsyncHandler<DownloadDBLogFilePortionRequest, DownloadDBLogFilePortionResult> asyncHandler) {
        return this.executorService.submit(new Callable<DownloadDBLogFilePortionResult>(){

            @Override
            public DownloadDBLogFilePortionResult call() throws Exception {
                DownloadDBLogFilePortionResult result;
                try {
                    result = AmazonRDSAsyncClient.this.downloadDBLogFilePortion(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBCluster> failoverDBClusterAsync(FailoverDBClusterRequest request) {
        return this.failoverDBClusterAsync(request, null);
    }

    @Override
    public Future<DBCluster> failoverDBClusterAsync(final FailoverDBClusterRequest request, final AsyncHandler<FailoverDBClusterRequest, DBCluster> asyncHandler) {
        return this.executorService.submit(new Callable<DBCluster>(){

            @Override
            public DBCluster call() throws Exception {
                DBCluster result;
                try {
                    result = AmazonRDSAsyncClient.this.failoverDBCluster(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBCluster> failoverDBClusterAsync() {
        return this.failoverDBClusterAsync(new FailoverDBClusterRequest());
    }

    @Override
    public Future<DBCluster> failoverDBClusterAsync(AsyncHandler<FailoverDBClusterRequest, DBCluster> asyncHandler) {
        return this.failoverDBClusterAsync(new FailoverDBClusterRequest(), asyncHandler);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(final ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result;
                try {
                    result = AmazonRDSAsyncClient.this.listTagsForResource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBCluster> modifyDBClusterAsync(ModifyDBClusterRequest request) {
        return this.modifyDBClusterAsync(request, null);
    }

    @Override
    public Future<DBCluster> modifyDBClusterAsync(final ModifyDBClusterRequest request, final AsyncHandler<ModifyDBClusterRequest, DBCluster> asyncHandler) {
        return this.executorService.submit(new Callable<DBCluster>(){

            @Override
            public DBCluster call() throws Exception {
                DBCluster result;
                try {
                    result = AmazonRDSAsyncClient.this.modifyDBCluster(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ModifyDBClusterParameterGroupResult> modifyDBClusterParameterGroupAsync(ModifyDBClusterParameterGroupRequest request) {
        return this.modifyDBClusterParameterGroupAsync(request, null);
    }

    @Override
    public Future<ModifyDBClusterParameterGroupResult> modifyDBClusterParameterGroupAsync(final ModifyDBClusterParameterGroupRequest request, final AsyncHandler<ModifyDBClusterParameterGroupRequest, ModifyDBClusterParameterGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<ModifyDBClusterParameterGroupResult>(){

            @Override
            public ModifyDBClusterParameterGroupResult call() throws Exception {
                ModifyDBClusterParameterGroupResult result;
                try {
                    result = AmazonRDSAsyncClient.this.modifyDBClusterParameterGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBClusterSnapshotAttributesResult> modifyDBClusterSnapshotAttributeAsync(ModifyDBClusterSnapshotAttributeRequest request) {
        return this.modifyDBClusterSnapshotAttributeAsync(request, null);
    }

    @Override
    public Future<DBClusterSnapshotAttributesResult> modifyDBClusterSnapshotAttributeAsync(final ModifyDBClusterSnapshotAttributeRequest request, final AsyncHandler<ModifyDBClusterSnapshotAttributeRequest, DBClusterSnapshotAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DBClusterSnapshotAttributesResult>(){

            @Override
            public DBClusterSnapshotAttributesResult call() throws Exception {
                DBClusterSnapshotAttributesResult result;
                try {
                    result = AmazonRDSAsyncClient.this.modifyDBClusterSnapshotAttribute(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBInstance> modifyDBInstanceAsync(ModifyDBInstanceRequest request) {
        return this.modifyDBInstanceAsync(request, null);
    }

    @Override
    public Future<DBInstance> modifyDBInstanceAsync(final ModifyDBInstanceRequest request, final AsyncHandler<ModifyDBInstanceRequest, DBInstance> asyncHandler) {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                DBInstance result;
                try {
                    result = AmazonRDSAsyncClient.this.modifyDBInstance(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ModifyDBParameterGroupResult> modifyDBParameterGroupAsync(ModifyDBParameterGroupRequest request) {
        return this.modifyDBParameterGroupAsync(request, null);
    }

    @Override
    public Future<ModifyDBParameterGroupResult> modifyDBParameterGroupAsync(final ModifyDBParameterGroupRequest request, final AsyncHandler<ModifyDBParameterGroupRequest, ModifyDBParameterGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<ModifyDBParameterGroupResult>(){

            @Override
            public ModifyDBParameterGroupResult call() throws Exception {
                ModifyDBParameterGroupResult result;
                try {
                    result = AmazonRDSAsyncClient.this.modifyDBParameterGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBSnapshotAttributesResult> modifyDBSnapshotAttributeAsync(ModifyDBSnapshotAttributeRequest request) {
        return this.modifyDBSnapshotAttributeAsync(request, null);
    }

    @Override
    public Future<DBSnapshotAttributesResult> modifyDBSnapshotAttributeAsync(final ModifyDBSnapshotAttributeRequest request, final AsyncHandler<ModifyDBSnapshotAttributeRequest, DBSnapshotAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DBSnapshotAttributesResult>(){

            @Override
            public DBSnapshotAttributesResult call() throws Exception {
                DBSnapshotAttributesResult result;
                try {
                    result = AmazonRDSAsyncClient.this.modifyDBSnapshotAttribute(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBSubnetGroup> modifyDBSubnetGroupAsync(ModifyDBSubnetGroupRequest request) {
        return this.modifyDBSubnetGroupAsync(request, null);
    }

    @Override
    public Future<DBSubnetGroup> modifyDBSubnetGroupAsync(final ModifyDBSubnetGroupRequest request, final AsyncHandler<ModifyDBSubnetGroupRequest, DBSubnetGroup> asyncHandler) {
        return this.executorService.submit(new Callable<DBSubnetGroup>(){

            @Override
            public DBSubnetGroup call() throws Exception {
                DBSubnetGroup result;
                try {
                    result = AmazonRDSAsyncClient.this.modifyDBSubnetGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EventSubscription> modifyEventSubscriptionAsync(ModifyEventSubscriptionRequest request) {
        return this.modifyEventSubscriptionAsync(request, null);
    }

    @Override
    public Future<EventSubscription> modifyEventSubscriptionAsync(final ModifyEventSubscriptionRequest request, final AsyncHandler<ModifyEventSubscriptionRequest, EventSubscription> asyncHandler) {
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                EventSubscription result;
                try {
                    result = AmazonRDSAsyncClient.this.modifyEventSubscription(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<OptionGroup> modifyOptionGroupAsync(ModifyOptionGroupRequest request) {
        return this.modifyOptionGroupAsync(request, null);
    }

    @Override
    public Future<OptionGroup> modifyOptionGroupAsync(final ModifyOptionGroupRequest request, final AsyncHandler<ModifyOptionGroupRequest, OptionGroup> asyncHandler) {
        return this.executorService.submit(new Callable<OptionGroup>(){

            @Override
            public OptionGroup call() throws Exception {
                OptionGroup result;
                try {
                    result = AmazonRDSAsyncClient.this.modifyOptionGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBInstance> promoteReadReplicaAsync(PromoteReadReplicaRequest request) {
        return this.promoteReadReplicaAsync(request, null);
    }

    @Override
    public Future<DBInstance> promoteReadReplicaAsync(final PromoteReadReplicaRequest request, final AsyncHandler<PromoteReadReplicaRequest, DBInstance> asyncHandler) {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                DBInstance result;
                try {
                    result = AmazonRDSAsyncClient.this.promoteReadReplica(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBCluster> promoteReadReplicaDBClusterAsync(PromoteReadReplicaDBClusterRequest request) {
        return this.promoteReadReplicaDBClusterAsync(request, null);
    }

    @Override
    public Future<DBCluster> promoteReadReplicaDBClusterAsync(final PromoteReadReplicaDBClusterRequest request, final AsyncHandler<PromoteReadReplicaDBClusterRequest, DBCluster> asyncHandler) {
        return this.executorService.submit(new Callable<DBCluster>(){

            @Override
            public DBCluster call() throws Exception {
                DBCluster result;
                try {
                    result = AmazonRDSAsyncClient.this.promoteReadReplicaDBCluster(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ReservedDBInstance> purchaseReservedDBInstancesOfferingAsync(PurchaseReservedDBInstancesOfferingRequest request) {
        return this.purchaseReservedDBInstancesOfferingAsync(request, null);
    }

    @Override
    public Future<ReservedDBInstance> purchaseReservedDBInstancesOfferingAsync(final PurchaseReservedDBInstancesOfferingRequest request, final AsyncHandler<PurchaseReservedDBInstancesOfferingRequest, ReservedDBInstance> asyncHandler) {
        return this.executorService.submit(new Callable<ReservedDBInstance>(){

            @Override
            public ReservedDBInstance call() throws Exception {
                ReservedDBInstance result;
                try {
                    result = AmazonRDSAsyncClient.this.purchaseReservedDBInstancesOffering(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBInstance> rebootDBInstanceAsync(RebootDBInstanceRequest request) {
        return this.rebootDBInstanceAsync(request, null);
    }

    @Override
    public Future<DBInstance> rebootDBInstanceAsync(final RebootDBInstanceRequest request, final AsyncHandler<RebootDBInstanceRequest, DBInstance> asyncHandler) {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                DBInstance result;
                try {
                    result = AmazonRDSAsyncClient.this.rebootDBInstance(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EventSubscription> removeSourceIdentifierFromSubscriptionAsync(RemoveSourceIdentifierFromSubscriptionRequest request) {
        return this.removeSourceIdentifierFromSubscriptionAsync(request, null);
    }

    @Override
    public Future<EventSubscription> removeSourceIdentifierFromSubscriptionAsync(final RemoveSourceIdentifierFromSubscriptionRequest request, final AsyncHandler<RemoveSourceIdentifierFromSubscriptionRequest, EventSubscription> asyncHandler) {
        return this.executorService.submit(new Callable<EventSubscription>(){

            @Override
            public EventSubscription call() throws Exception {
                EventSubscription result;
                try {
                    result = AmazonRDSAsyncClient.this.removeSourceIdentifierFromSubscription(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveTagsFromResourceResult> removeTagsFromResourceAsync(RemoveTagsFromResourceRequest request) {
        return this.removeTagsFromResourceAsync(request, null);
    }

    @Override
    public Future<RemoveTagsFromResourceResult> removeTagsFromResourceAsync(final RemoveTagsFromResourceRequest request, final AsyncHandler<RemoveTagsFromResourceRequest, RemoveTagsFromResourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<RemoveTagsFromResourceResult>(){

            @Override
            public RemoveTagsFromResourceResult call() throws Exception {
                RemoveTagsFromResourceResult result;
                try {
                    result = AmazonRDSAsyncClient.this.removeTagsFromResource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ResetDBClusterParameterGroupResult> resetDBClusterParameterGroupAsync(ResetDBClusterParameterGroupRequest request) {
        return this.resetDBClusterParameterGroupAsync(request, null);
    }

    @Override
    public Future<ResetDBClusterParameterGroupResult> resetDBClusterParameterGroupAsync(final ResetDBClusterParameterGroupRequest request, final AsyncHandler<ResetDBClusterParameterGroupRequest, ResetDBClusterParameterGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<ResetDBClusterParameterGroupResult>(){

            @Override
            public ResetDBClusterParameterGroupResult call() throws Exception {
                ResetDBClusterParameterGroupResult result;
                try {
                    result = AmazonRDSAsyncClient.this.resetDBClusterParameterGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ResetDBParameterGroupResult> resetDBParameterGroupAsync(ResetDBParameterGroupRequest request) {
        return this.resetDBParameterGroupAsync(request, null);
    }

    @Override
    public Future<ResetDBParameterGroupResult> resetDBParameterGroupAsync(final ResetDBParameterGroupRequest request, final AsyncHandler<ResetDBParameterGroupRequest, ResetDBParameterGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<ResetDBParameterGroupResult>(){

            @Override
            public ResetDBParameterGroupResult call() throws Exception {
                ResetDBParameterGroupResult result;
                try {
                    result = AmazonRDSAsyncClient.this.resetDBParameterGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBCluster> restoreDBClusterFromS3Async(RestoreDBClusterFromS3Request request) {
        return this.restoreDBClusterFromS3Async(request, null);
    }

    @Override
    public Future<DBCluster> restoreDBClusterFromS3Async(final RestoreDBClusterFromS3Request request, final AsyncHandler<RestoreDBClusterFromS3Request, DBCluster> asyncHandler) {
        return this.executorService.submit(new Callable<DBCluster>(){

            @Override
            public DBCluster call() throws Exception {
                DBCluster result;
                try {
                    result = AmazonRDSAsyncClient.this.restoreDBClusterFromS3(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBCluster> restoreDBClusterFromSnapshotAsync(RestoreDBClusterFromSnapshotRequest request) {
        return this.restoreDBClusterFromSnapshotAsync(request, null);
    }

    @Override
    public Future<DBCluster> restoreDBClusterFromSnapshotAsync(final RestoreDBClusterFromSnapshotRequest request, final AsyncHandler<RestoreDBClusterFromSnapshotRequest, DBCluster> asyncHandler) {
        return this.executorService.submit(new Callable<DBCluster>(){

            @Override
            public DBCluster call() throws Exception {
                DBCluster result;
                try {
                    result = AmazonRDSAsyncClient.this.restoreDBClusterFromSnapshot(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBCluster> restoreDBClusterToPointInTimeAsync(RestoreDBClusterToPointInTimeRequest request) {
        return this.restoreDBClusterToPointInTimeAsync(request, null);
    }

    @Override
    public Future<DBCluster> restoreDBClusterToPointInTimeAsync(final RestoreDBClusterToPointInTimeRequest request, final AsyncHandler<RestoreDBClusterToPointInTimeRequest, DBCluster> asyncHandler) {
        return this.executorService.submit(new Callable<DBCluster>(){

            @Override
            public DBCluster call() throws Exception {
                DBCluster result;
                try {
                    result = AmazonRDSAsyncClient.this.restoreDBClusterToPointInTime(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBInstance> restoreDBInstanceFromDBSnapshotAsync(RestoreDBInstanceFromDBSnapshotRequest request) {
        return this.restoreDBInstanceFromDBSnapshotAsync(request, null);
    }

    @Override
    public Future<DBInstance> restoreDBInstanceFromDBSnapshotAsync(final RestoreDBInstanceFromDBSnapshotRequest request, final AsyncHandler<RestoreDBInstanceFromDBSnapshotRequest, DBInstance> asyncHandler) {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                DBInstance result;
                try {
                    result = AmazonRDSAsyncClient.this.restoreDBInstanceFromDBSnapshot(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBInstance> restoreDBInstanceToPointInTimeAsync(RestoreDBInstanceToPointInTimeRequest request) {
        return this.restoreDBInstanceToPointInTimeAsync(request, null);
    }

    @Override
    public Future<DBInstance> restoreDBInstanceToPointInTimeAsync(final RestoreDBInstanceToPointInTimeRequest request, final AsyncHandler<RestoreDBInstanceToPointInTimeRequest, DBInstance> asyncHandler) {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                DBInstance result;
                try {
                    result = AmazonRDSAsyncClient.this.restoreDBInstanceToPointInTime(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DBSecurityGroup> revokeDBSecurityGroupIngressAsync(RevokeDBSecurityGroupIngressRequest request) {
        return this.revokeDBSecurityGroupIngressAsync(request, null);
    }

    @Override
    public Future<DBSecurityGroup> revokeDBSecurityGroupIngressAsync(final RevokeDBSecurityGroupIngressRequest request, final AsyncHandler<RevokeDBSecurityGroupIngressRequest, DBSecurityGroup> asyncHandler) {
        return this.executorService.submit(new Callable<DBSecurityGroup>(){

            @Override
            public DBSecurityGroup call() throws Exception {
                DBSecurityGroup result;
                try {
                    result = AmazonRDSAsyncClient.this.revokeDBSecurityGroupIngress(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

