/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.logs.model.CreateLogStreamRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateLogStreamRequestMarshaller
implements Marshaller<Request<CreateLogStreamRequest>, CreateLogStreamRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateLogStreamRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateLogStreamRequest> marshall(CreateLogStreamRequest createLogStreamRequest) {
        if (createLogStreamRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateLogStreamRequest> request = new DefaultRequest<CreateLogStreamRequest>(createLogStreamRequest, "AWSLogs");
        request.addHeader("X-Amz-Target", "Logs_20140328.CreateLogStream");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createLogStreamRequest.getLogGroupName() != null) {
                jsonGenerator.writeFieldName("logGroupName").writeValue(createLogStreamRequest.getLogGroupName());
            }
            if (createLogStreamRequest.getLogStreamName() != null) {
                jsonGenerator.writeFieldName("logStreamName").writeValue(createLogStreamRequest.getLogStreamName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

